/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg.registers.common;

import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.world_gen.features.RandomSurfaceDecoration;
import com.robertx22.mine_and_slash.world_gen.features.RandomSurfaceEggFeature;
import com.robertx22.mine_and_slash.world_gen.features.RandomSurfaceTreasure;
import com.robertx22.mine_and_slash.world_gen.structures.Random1ChunkDunStructure;
import com.robertx22.mine_and_slash.world_gen.structures.TowerStructure;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.AtSurfaceWithChance;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="mmorpg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WorldGenRegisters {
    public static final int SMALL_DECO_CHANCE = 50;
    public static final ConfiguredFeature randomSurfaceChest = WorldGenRegisters.create(new RandomSurfaceEggFeature(NoFeatureConfig::func_214639_a), new AtSurfaceWithChance(ChanceConfig::func_214722_a), new ChanceConfig(1000));
    public static final ConfiguredFeature smallRandomSurfaceDecoration = WorldGenRegisters.createSmallSurfaceDeco(new RandomSurfaceDecoration(NoFeatureConfig::func_214639_a));
    public static final ConfiguredFeature smallRandomSurfaceTreasure = Biome.func_222280_a((Feature)new RandomSurfaceTreasure(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215026_l, (IPlacementConfig)new ChanceConfig(400));
    public static Structure<NoFeatureConfig> towerStructure = null;
    public static Structure<NoFeatureConfig> dungeon0Structure = null;

    public static void register() {
        System.out.println("Registering Mine and Slash Map World Gen");
        WorldGenRegisters.registerStructure(towerStructure);
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (SlashRegistry.WorldProviders().getAll().values().stream().filter(iwp -> iwp.getBiome().equals(biome)).collect(Collectors.toList()).size() <= 0) continue;
            WorldGenRegisters.add(biome, randomSurfaceChest);
            WorldGenRegisters.add(biome, smallRandomSurfaceDecoration);
            WorldGenRegisters.add(biome, smallRandomSurfaceTreasure);
            biome.func_201865_a(towerStructure, (IFeatureConfig)IFeatureConfig.field_202429_e);
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(towerStructure, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
            biome.func_201865_a(dungeon0Structure, (IFeatureConfig)IFeatureConfig.field_202429_e);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_222280_a(dungeon0Structure, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
        }
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        towerStructure = WorldGenRegisters.registerStructure(new TowerStructure(NoFeatureConfig::func_214639_a));
        dungeon0Structure = WorldGenRegisters.registerStructure(new Random1ChunkDunStructure(NoFeatureConfig::func_214639_a));
        event.getRegistry().register(towerStructure);
        event.getRegistry().register(dungeon0Structure);
    }

    private static <C extends IFeatureConfig, F extends Structure<C>> F registerStructure(F value) {
        Feature.field_202300_at.put((Object)value.func_143025_a(), value);
        WorldGenRegisters.registerStruc(value.func_143025_a(), value);
        return (F)((Structure)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)value.func_143025_a(), value));
    }

    private static Structure<?> registerStruc(String id, Structure<?> structure) {
        return (Structure)Registry.func_218325_a((Registry)Registry.field_218361_B, (String)id.toLowerCase(Locale.ROOT), structure);
    }

    public static void add(Biome biome, ConfiguredFeature comp) {
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, comp);
    }

    public static ConfiguredFeature createSmallSurfaceDeco(Feature feature) {
        return Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215026_l, (IPlacementConfig)new ChanceConfig(50));
    }

    public static <F extends IFeatureConfig, D extends IPlacementConfig> ConfiguredFeature<F> create(Feature feature, Placement<D> basePlacementIn, D placementConfig) {
        return Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, basePlacementIn, placementConfig);
    }
}

