/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.network;

import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.professions.blocks.bases.ProfessionContainer;
import com.robertx22.mine_and_slash.professions.blocks.bases.ProfessionTile;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ProfessionRecipePacket {
    public BlockPos pos;
    public String recipeGUID;

    public ProfessionRecipePacket() {
    }

    public ProfessionRecipePacket(BlockPos pos, BaseRecipe recipe) {
        this.pos = pos;
        this.recipeGUID = recipe.GUID();
    }

    public static ProfessionRecipePacket decode(PacketBuffer buf) {
        ProfessionRecipePacket newpkt = new ProfessionRecipePacket();
        newpkt.pos = buf.func_179259_c();
        newpkt.recipeGUID = buf.func_150789_c(50);
        return newpkt;
    }

    public static void encode(ProfessionRecipePacket packet, PacketBuffer tag) {
        tag.func_179255_a(packet.pos);
        tag.func_180714_a(packet.recipeGUID);
    }

    public static void handle(ProfessionRecipePacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                TileEntity tile;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (tile = player.field_70170_p.func_175625_s(pkt.pos)) instanceof ProfessionTile) {
                    BaseRecipe recipe = pkt.recipeGUID.isEmpty() ? null : SlashRegistry.Recipes().get(pkt.recipeGUID);
                    ProfessionTile prof = (ProfessionTile)tile;
                    prof.currentRecipe = recipe;
                    Container container = player.field_71070_bA;
                    if (container instanceof ProfessionContainer) {
                        ProfessionContainer profcont = (ProfessionContainer)container;
                        profcont.onRecipeChoosen(recipe);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

