/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.network;

import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.rarities.base.DropSoundData;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class RarityItemDropPacket {
    public int rarity;
    public BlockPos pos;

    public RarityItemDropPacket() {
    }

    public RarityItemDropPacket(int rar, BlockPos pos) {
        this.rarity = rar;
        this.pos = pos;
    }

    public static RarityItemDropPacket decode(PacketBuffer buf) {
        RarityItemDropPacket newpkt = new RarityItemDropPacket();
        newpkt.rarity = buf.readInt();
        newpkt.pos = buf.func_179259_c();
        return newpkt;
    }

    public static void encode(RarityItemDropPacket packet, PacketBuffer tag) {
        tag.writeInt(packet.rarity);
        tag.func_179255_a(packet.pos);
    }

    public static void handle(RarityItemDropPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                GearRarity rar;
                DropSoundData data;
                PlayerEntity player = MMORPG.proxy.getPlayerEntityFromContext(ctx);
                if (player != null && (data = (rar = (GearRarity)Rarities.Items.get(pkt.rarity)).getDropSound()).hasSound()) {
                    player.field_70170_p.func_184133_a(player, pkt.pos, data.sound, SoundCategory.PLAYERS, data.volume, data.pitch);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

