/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.network.sync_cap;

import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.network.sync_cap.CapTypes;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncCapabilityToClient {
    private CompoundNBT nbt;
    private CapTypes type;

    public SyncCapabilityToClient() {
    }

    public SyncCapabilityToClient(ServerPlayerEntity p, CapTypes type) {
        this.nbt = type.getCap((PlayerEntity)p).getNBT();
        this.type = type;
    }

    public static SyncCapabilityToClient decode(PacketBuffer buf) {
        SyncCapabilityToClient newpkt = new SyncCapabilityToClient();
        newpkt.nbt = buf.func_150793_b();
        newpkt.type = (CapTypes)buf.func_179257_a(CapTypes.class);
        return newpkt;
    }

    public static void encode(SyncCapabilityToClient packet, PacketBuffer tag) {
        tag.func_150786_a(packet.nbt);
        tag.func_179249_a((Enum)packet.type);
    }

    public static void handle(SyncCapabilityToClient pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                PlayerEntity player = MMORPG.proxy.getPlayerEntityFromContext(ctx);
                if (player != null) {
                    pkt.type.getCap(player).setNBT(pkt.nbt);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

