/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content_test.blueprints;

import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.new_content_test.blueprints.BlueprintGearReward;
import com.robertx22.mine_and_slash.new_content_test.blueprints.requests.BlueprintDataItemRequest;
import com.robertx22.mine_and_slash.new_content_test.blueprints.requests.BlueprintSimpleItemRequest;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.datasaving.Blueprint;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.DataItemType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ISalvagable;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

@Storable
public class BlueprintItemData
implements ICommonDataItem<GearRarity> {
    @Store
    public List<BlueprintDataItemRequest> dataRequests = new ArrayList<BlueprintDataItemRequest>();
    @Store
    public List<BlueprintSimpleItemRequest> simpleItemRequests = new ArrayList<BlueprintSimpleItemRequest>();
    @Store
    public BlueprintGearReward gearReward = new BlueprintGearReward();
    @Store
    public int level;
    @Store
    public int tier;
    @Store
    public int rarity;

    @Override
    public void saveToStack(ItemStack stack) {
        Blueprint.Save(stack, this);
    }

    public int getDifficulty() {
        int diff = 0;
        diff += this.dataRequests.stream().mapToInt(BlueprintDataItemRequest::getDifficultyValue).sum();
        return diff += this.simpleItemRequests.stream().mapToInt(BlueprintSimpleItemRequest::getDifficultyValue).sum();
    }

    @Override
    public DataItemType getDataType() {
        return DataItemType.BLUEPRINT;
    }

    @Override
    public String getUniqueGUID() {
        return "";
    }

    @Override
    public void BuildTooltip(TooltipContext ctx) {
        List tooltip = ctx.event.getToolTip();
        TooltipInfo info = new TooltipInfo();
        tooltip.add(Words.Requirements.locName().func_150258_a(": "));
        this.dataRequests.forEach(x -> tooltip.addAll(x.GetTooltipString(info)));
        this.simpleItemRequests.forEach(x -> tooltip.addAll(x.GetTooltipString(info)));
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getRarityRank() {
        return this.rarity;
    }

    @Override
    public GearRarity getRarity() {
        return (GearRarity)Rarities.Items.get(this.rarity);
    }

    @Override
    public ItemStack getSalvageResult(float salvageBonus) {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean isSalvagable(ISalvagable.SalvageContext context) {
        return false;
    }

    @Override
    public int Tier() {
        return this.tier;
    }

    @Override
    public String getSpecificType() {
        return "";
    }
}

