/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content_test.blueprints.requests;

import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.new_content_test.blueprints.requests.BaseBlueprintRequest;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.DataItemType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

@Storable
public class BlueprintDataItemRequest
extends BaseBlueprintRequest {
    @Store
    public int level;
    @Store
    public int tier;
    @Store
    public String specificType;
    @Store
    public int rarity;
    @Store
    public String uniqueID;
    @Store
    public DataItemType dataItemType;

    public BlueprintDataItemRequest() {
        this.level = this.UNUSED_INT;
        this.tier = this.UNUSED_INT;
        this.specificType = "";
        this.rarity = this.UNUSED_INT;
    }

    @Override
    public void random(GearRarity rar) {
    }

    @Override
    public int getDifficultyValue() {
        int diff = 1000;
        diff = (int)((float)diff * BaseBlueprintRequest.getRarityDifficultyMulti(this.rarity));
        diff = (int)((float)diff * BaseBlueprintRequest.getTierDifficultyMulti(this.tier));
        return diff *= this.uniqueID.isEmpty() ? 1 : 2;
    }

    @Override
    public boolean matches(ItemStack stack) {
        ICommonDataItem data = ICommonDataItem.load(stack);
        if (data.getDataType() == this.dataItemType) {
            if (!this.uniqueID.isEmpty() && !this.uniqueID.equals(data.getUniqueGUID())) {
                return false;
            }
            return data != null && data.Tier() >= this.tier && data.getLevel() >= this.level && data.getSpecificType().equals(this.specificType);
        }
        return false;
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (this.level != this.UNUSED_INT) {
            list.add(Words.Level.locName().func_150258_a(" : " + this.level));
        }
        if (this.tier != this.UNUSED_INT) {
            list.add(Words.Tier.locName().func_150258_a(" : " + this.tier));
        }
        if (this.rarity != this.UNUSED_INT) {
            list.add(Words.Rarity.locName().func_150258_a(" : " + this.rarity));
        }
        return list;
    }
}

