/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.entity.damage;

import com.robertx22.mine_and_slash.a_libraries.curios.MyCurioUtils;
import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.config.mod_dmg_whitelist.ModDmgWhitelistContainer;
import com.robertx22.mine_and_slash.database.spells.bases.MyDamageSource;
import com.robertx22.mine_and_slash.onevent.entity.damage.DmgSourceUtils;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LivingHurtUtils {
    public static void damageCurioItems(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            List<ItemStack> curios = MyCurioUtils.getAllSlots(player);
            curios.forEach(x -> x.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND)));
        }
    }

    public static void damageArmorItems(LivingHurtEvent event) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        event.getEntityLiving().func_184193_aE().forEach(x -> stacks.add((ItemStack)x));
        stacks.add(event.getEntityLiving().func_184592_cb());
        stacks.forEach(x -> x.func_222118_a(1, event.getEntityLiving(), entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND)));
    }

    public static void onAttack(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        if (target.field_70170_p.field_72995_K) {
            return;
        }
        if (event.getSource() != null) {
            if (LivingHurtUtils.isForbiddenAttack(event)) {
                return;
            }
            if (event.getSource() instanceof MyDamageSource || event.getSource().func_76355_l().equals(DamageEffect.dmgSourceName)) {
                return;
            }
            if (event.getSource().func_76346_g() instanceof LivingEntity) {
                LivingEntity source = (LivingEntity)event.getSource().func_76346_g();
                LivingHurtUtils.onAttack(source, target, event.getAmount(), event);
            }
        }
    }

    public static void onAttack(LivingEntity source, LivingEntity target, float amount, LivingHurtEvent event) {
        try {
            if (!target.func_70089_S()) {
                return;
            }
            EntityCap.UnitData sourceData = Load.Unit((ICapabilityProvider)source);
            if (sourceData == null) {
                return;
            }
            GearItemData weapondata = sourceData.getWeaponData(source);
            EntityCap.UnitData targetData = Load.Unit((ICapabilityProvider)target);
            if (targetData == null) {
                return;
            }
            targetData.recalculateStats(target);
            sourceData.recalculateStats(source);
            if (source instanceof PlayerEntity) {
                ItemStack weapon;
                ModDmgWhitelistContainer.ModDmgWhitelist mod;
                if (weapondata == null && (mod = ModDmgWhitelistContainer.getModDmgWhitelist(weapon = source.func_184614_ca())) != null) {
                    return;
                }
                if (sourceData.isWeapon(weapondata)) {
                    if (sourceData.tryUseWeapon(weapondata, source)) {
                        sourceData.attackWithWeapon(event, source.func_184614_ca(), weapondata, source, target, targetData);
                    }
                } else {
                    sourceData.unarmedAttack(event, source, target, targetData);
                }
            } else {
                sourceData.mobBasicAttack(event, source, target, sourceData, targetData, amount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isForbiddenAttack(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity en = (LivingEntity)event.getSource().func_76346_g();
            DamageSource source = event.getSource();
            Item item = en.func_184614_ca().func_77973_b();
            if (item instanceof BowItem || item instanceof CrossbowItem) {
                return !source.func_76352_a();
            }
            return source instanceof IndirectEntityDamageSource;
        }
        return false;
    }

    public static void modifyDamage(LivingHurtEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getSource() == null) {
            return;
        }
        if (DmgSourceUtils.isMyDmgSource(event.getSource())) {
            DmgSourceUtils.removeSourceMarker(event.getSource());
            LivingHurtUtils.damageArmorItems(event);
            return;
        }
        if (LivingHurtUtils.isEnviromentalDmg(event.getSource())) {
            if (!(event.getEntity() instanceof PlayerEntity)) {
                event.setAmount(event.getAmount() * ((Double)ModConfig.INSTANCE.Server.MOB_ENVIRONMENT_DAMAGE_MULTI.get()).floatValue());
                return;
            }
        } else {
            LivingEntity en = (LivingEntity)event.getSource().func_76346_g();
            ModDmgWhitelistContainer.ModDmgWhitelist mod = ModDmgWhitelistContainer.getModDmgWhitelist(en.func_184614_ca());
            if (mod != null) {
                event.setAmount(event.getAmount() * mod.dmgMultiplier);
                return;
            }
            event.setAmount(event.getAmount() * ((Double)ModConfig.INSTANCE.Server.NON_MOD_DAMAGE_MULTI.get()).floatValue());
            return;
        }
    }

    public static boolean isEnviromentalDmg(DamageSource source) {
        return !(source.func_76346_g() instanceof LivingEntity);
    }

    public static void onHurtRecordNonPlayerDmg(LivingHurtEvent event) {
        LivingEntity defender = event.getEntityLiving();
        if (!(defender instanceof PlayerEntity)) {
            if (event.getSource() != null) {
                EntityCap.UnitData data;
                Entity attacker = event.getSource().func_76346_g();
                if (!(attacker instanceof PlayerEntity) && (data = Load.Unit((ICapabilityProvider)event.getEntityLiving())) != null) {
                    data.onDamagedByNonPlayer(defender, event.getAmount());
                    data.trySync(defender);
                }
            } else {
                EntityCap.UnitData data = Load.Unit((ICapabilityProvider)event.getEntityLiving());
                if (data != null) {
                    data.onDamagedByNonPlayer(defender, event.getAmount());
                    data.trySync(defender);
                }
            }
        }
    }
}

