/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.item;

import com.robertx22.mine_and_slash.database.items.currency.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.items.misc.ItemMapBackPortal;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.item_classes.MapItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.RecipeItemData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.Recipe;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OnTooltip {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemTooltip(ItemTooltipEvent event) {
        OnTooltip.buildDataTootltip(event);
        OnTooltip.buildCurrencyEffectTooltip(event);
    }

    private static void buildDataTootltip(ItemTooltipEvent event) {
        try {
            ITextComponent broken;
            if (Screen.hasControlDown()) {
                return;
            }
            if (event.getEntityPlayer() == null || event.getEntityPlayer().field_70170_p == null || !event.getEntityPlayer().field_70170_p.field_72995_K) {
                return;
            }
            ItemStack stack = event.getItemStack();
            EntityCap.UnitData unitdata = Load.Unit((ICapabilityProvider)event.getEntityPlayer());
            if (unitdata == null) {
                return;
            }
            Unit unit = unitdata.getUnit();
            if (unit == null) {
                return;
            }
            TooltipContext ctx = new TooltipContext(stack, event, unitdata);
            if (stack.func_77973_b() instanceof ItemMapBackPortal) {
                try {
                    event.getToolTip().add(Styles.BLUECOMP().func_150257_a(Words.CurrentMapInfo.locName()).func_150258_a(": "));
                    MapItemData map = Load.playerMapData(event.getEntityPlayer()).getMap();
                    map.BuildTooltip(ctx);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            if (!stack.func_77942_o()) {
                return;
            }
            ICommonDataItem data = ICommonDataItem.load(stack);
            if (data != null) {
                data.BuildTooltip(ctx);
            } else if (stack.func_77973_b().getRegistryName() != null && SlashRegistry.CompatibleItems().isRegistered(stack.func_77973_b().getRegistryName().toString())) {
                event.getToolTip().add(new StringTextComponent(Styles.RED + "Compatible Mine and Slash Item"));
            }
            RecipeItemData recipe = Recipe.Load(stack);
            if (recipe != null) {
                recipe.BuildTooltip(ctx);
            }
            if ((broken = TooltipUtils.itemBrokenText(stack, data)) != null) {
                event.getToolTip().add(broken);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void buildCurrencyEffectTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() instanceof ICurrencyItemEffect) {
            ICurrencyItemEffect currency = (ICurrencyItemEffect)event.getItemStack().func_77973_b();
            currency.addToTooltip(event.getToolTip());
        }
    }
}

