/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.ontick;

import com.robertx22.mine_and_slash.database.stats.types.resources.EnergyRegen;
import com.robertx22.mine_and_slash.database.stats.types.resources.HealthRegen;
import com.robertx22.mine_and_slash.database.stats.types.resources.MagicShieldRegen;
import com.robertx22.mine_and_slash.database.stats.types.resources.ManaRegen;
import com.robertx22.mine_and_slash.items.misc.ItemMapBackPortal;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.network.sync_cap.CapTypes;
import com.robertx22.mine_and_slash.network.sync_cap.SyncCapabilityToClient;
import com.robertx22.mine_and_slash.professions.blocks.bases.ProfessionContainer;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class OnTickLogic {
    static final int TicksToUpdatePlayer = 18;
    static final int TicksToRegen = 100;
    static final int TicksToGiveMapPortal = 400;
    static final int TicksToPassMinute = 1200;
    public static HashMap<UUID, PlayerTickData> PlayerTickDatas = new HashMap();

    @SubscribeEvent
    public static void onTickLogicVoid(TickEvent.PlayerTickEvent event) {
        if (event.side.equals((Object)LogicalSide.SERVER) && event.phase == TickEvent.Phase.END) {
            try {
                ServerPlayerEntity player = (ServerPlayerEntity)event.player;
                PlayerTickData data = PlayerTickDatas.get(player.func_110124_au());
                if (data == null) {
                    data = new PlayerTickData();
                }
                data.increment();
                if (data.regenTicks > 100) {
                    data.regenTicks = 0;
                    if (player.func_70089_S()) {
                        EntityCap.UnitData unit_capa = Load.Unit((ICapabilityProvider)player);
                        unit_capa.forceRecalculateStats((LivingEntity)player);
                        Unit unit = unit_capa.getUnit();
                        int manarestored = (int)unit.getStat((String)ManaRegen.GUID).Value;
                        ResourcesData.Context mana = new ResourcesData.Context(unit_capa, (LivingEntity)player, ResourcesData.Type.MANA, manarestored, ResourcesData.Use.RESTORE);
                        unit_capa.getResources().modify(mana);
                        int energyrestored = (int)unit.getStat((String)EnergyRegen.GUID).Value;
                        ResourcesData.Context ene = new ResourcesData.Context(unit_capa, (LivingEntity)player, ResourcesData.Type.ENERGY, energyrestored, ResourcesData.Use.RESTORE);
                        unit_capa.getResources().modify(ene);
                        int healthrestored = (int)unit.getStat((String)HealthRegen.GUID).Value;
                        ResourcesData.Context hp = new ResourcesData.Context(unit_capa, (LivingEntity)player, ResourcesData.Type.HEALTH, healthrestored, ResourcesData.Use.RESTORE);
                        unit_capa.getResources().modify(hp);
                        int magicshieldrestored = (int)unit.getStat((String)MagicShieldRegen.GUID).Value;
                        ResourcesData.Context ms = new ResourcesData.Context(unit_capa, (LivingEntity)player, ResourcesData.Type.MAGIC_SHIELD, magicshieldrestored, ResourcesData.Use.RESTORE);
                        unit_capa.getResources().modify(ms);
                    }
                }
                if (data.mapPortalTicks > 400) {
                    ItemStack portalitem;
                    data.mapPortalTicks = 0;
                    if (WorldUtils.isMapWorld((IWorld)player.field_70170_p) && !player.field_71071_by.func_70431_c(portalitem = new ItemStack((IItemProvider)ItemMapBackPortal.ITEM))) {
                        player.field_71071_by.func_70441_a(portalitem);
                    }
                }
                if (data.playerSyncTick > 18) {
                    data.playerSyncTick = 0;
                    Load.Unit((ICapabilityProvider)player).syncToClient((PlayerEntity)player);
                    if (player.field_71070_bA instanceof ProfessionContainer) {
                        MMORPG.sendToClient(new SyncCapabilityToClient(player, CapTypes.PROFESSIONS), player);
                        ProfessionContainer prof = (ProfessionContainer)player.field_71070_bA;
                        prof.tile.onOpenByPlayer(player);
                    }
                }
                if (data.ticksToPassMinute > 1200) {
                    data.ticksToPassMinute = 0;
                    if (WorldUtils.isMapWorldClass((IWorld)player.field_70170_p)) {
                        Load.playerMapData((PlayerEntity)player).onMinute((PlayerEntity)player);
                    }
                }
                PlayerTickDatas.put(player.func_110124_au(), data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class PlayerTickData {
        public int regenTicks = 0;
        public int playerSyncTick = 0;
        public int mapPortalTicks = 0;
        public int ticksToPassMinute = 0;

        PlayerTickData() {
        }

        public void increment() {
            ++this.regenTicks;
            ++this.playerSyncTick;
            ++this.mapPortalTicks;
            ++this.ticksToPassMinute;
        }
    }
}

