/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.world;

import com.robertx22.mine_and_slash.config.ModConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

public class OnStartResetMaps {
    public static void OnStartResetMaps() {
        if (((Boolean)ModConfig.INSTANCE.Server.RESET_MAP_DIMENSIONS_ON_LOAD.get()).booleanValue()) {
            File file = new File(FMLPaths.GAMEDIR.get().toAbsolutePath().toString());
            for (File dir : Objects.requireNonNull(FileUtils.listFilesAndDirs((File)file, (IOFileFilter)new NoFilter(), (IOFileFilter)new NoFilter()))) {
                try {
                    if (!OnStartResetMaps.dirMatches(dir)) continue;
                    System.out.println("Deleting Resettable Map Folder from Mine and Slash");
                    OnStartResetMaps.deleteDirectoryRecursion(dir.toPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean dirMatches(File file) {
        String str = file.toPath().toString();
        return file.isDirectory() && str.contains("resettable") && str.contains("mmorpg");
    }

    static void deleteDirectoryRecursion(Path path) throws IOException {
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            try (DirectoryStream<Path> entries = Files.newDirectoryStream(path);){
                for (Path entry : entries) {
                    OnStartResetMaps.deleteDirectoryRecursion(entry);
                }
            }
        }
        Files.delete(path);
    }

    static class NoFilter
    implements IOFileFilter {
        NoFilter() {
        }

        public boolean accept(File file) {
            return true;
        }

        public boolean accept(File dir, String name) {
            return true;
        }
    }
}

