/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects;

import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class SpellPotionBase
extends Effect
implements IAutoLocName {
    public abstract void performEffectEverySetTime(LivingEntity var1, int var2);

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Potions;
    }

    @Override
    public String locNameLangFileGUID() {
        return this.getRegistryName().toString();
    }

    @Override
    public abstract String GUID();

    @Override
    public ITextComponent locName() {
        return CLOC.blank("effect.mmorpg" + this.GUID());
    }

    public abstract int performEachXTicks();

    public List<LivingEntity> getEntitiesAround(Entity en, float radius) {
        return en.field_70170_p.func_217357_a(LivingEntity.class, en.func_174813_aQ().func_186662_g((double)radius));
    }

    public ResourceLocation getIconTexture() {
        return new ResourceLocation("mmorpg", "textures/mob_effect/" + this.GUID() + ".png");
    }

    public void func_76394_a(LivingEntity en, int amplifier) {
        if (en.field_70173_aa % this.performEachXTicks() == 0) {
            this.performEffectEverySetTime(en, amplifier);
        }
    }

    protected SpellPotionBase(EffectType type, int liquidColorIn) {
        super(type, liquidColorIn);
    }

    protected boolean isServerSideOnly() {
        return true;
    }

    public boolean func_76397_a(int duration, int amplitude) {
        return duration >= 1;
    }

    public boolean func_76403_b() {
        return true;
    }

    public void func_180793_a(Entity applier, Entity caster, @Nonnull LivingEntity target, int amplifier, double health) {
        if (target.field_70170_p.field_72995_K && this.isServerSideOnly()) {
            return;
        }
        this.doEffect(applier, caster, target, amplifier);
    }

    public void func_111185_a(LivingEntity target, @Nonnull AbstractAttributeMap attributes, int amplifier) {
        if (!target.field_70170_p.field_72995_K || !this.isServerSideOnly()) {
            this.onPotionAdd(target, attributes, amplifier);
        }
        super.func_111185_a(target, attributes, amplifier);
    }

    public void func_111187_a(LivingEntity target, @Nonnull AbstractAttributeMap attributes, int amplifier) {
        super.func_111187_a(target, attributes, amplifier);
    }

    public void onPotionAdd(LivingEntity target, AbstractAttributeMap attributes, int amplifier) {
    }

    public void onPotionRemove(LivingEntity target, AbstractAttributeMap attributes, int amplifier) {
    }

    public abstract void doEffect(Entity var1, Entity var2, LivingEntity var3, int var4);

    protected boolean shouldShowParticles() {
        return true;
    }

    protected boolean isAmbient() {
        return false;
    }

    public EffectInstance toPotionEffect(int amplifier) {
        return this.toPotionEffect(1, amplifier);
    }

    public EffectInstance toPotionEffect(int duration, int amplifier) {
        return new EffectInstance((Effect)this, duration, amplifier, this.isAmbient(), this.shouldShowParticles());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUDEffect(EffectInstance effect, AbstractGui gui, int x, int y, float z, float alpha) {
        if (this.getIconTexture() != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getIconTexture());
            AbstractGui.blit((int)(x + 4), (int)(y + 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }
}

