/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.all;

import com.robertx22.mine_and_slash.potion_effects.SpellPotionBase;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class EnergyRegenPotion
extends SpellPotionBase {
    public static final EnergyRegenPotion INSTANCE = new EnergyRegenPotion();

    private EnergyRegenPotion() {
        super(EffectType.BENEFICIAL, 4393423);
        this.setRegistryName(new ResourceLocation("mmorpg", this.GUID()));
    }

    @Override
    public String locNameForLangFile() {
        return "Regen Energy";
    }

    @Override
    public String GUID() {
        return "energy_regen";
    }

    @Override
    public void performEffectEverySetTime(LivingEntity entity, int amplifier) {
        try {
            if (entity.field_70170_p.field_72995_K) {
                ParticleUtils.spawnEnergyRestoreParticles(entity, 5);
            } else {
                EntityCap.UnitData data = Load.Unit((ICapabilityProvider)entity);
                ResourcesData.Context energy = new ResourcesData.Context(data, entity, ResourcesData.Type.ENERGY, amplifier, ResourcesData.Use.RESTORE);
                data.getResources().modify(energy);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int performEachXTicks() {
        return 40;
    }

    @Override
    public void doEffect(Entity applier, Entity caster, LivingEntity target, int amplifier) {
    }
}

