/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.professions.blocks.bases;

import com.mojang.blaze3d.platform.GlStateManager;
import com.robertx22.mine_and_slash.blocks.slots.handlerslots.RecipeSlot;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.network.RequestTilePacket;
import com.robertx22.mine_and_slash.professions.blocks.bases.ProfessionContainer;
import com.robertx22.mine_and_slash.professions.blocks.bases.ProfessionTile;
import com.robertx22.mine_and_slash.professions.blocks.bases.widgets.ChooseRecipeButton;
import com.robertx22.mine_and_slash.professions.blocks.bases.widgets.OnlyLvlMetCheckBox;
import com.robertx22.mine_and_slash.professions.blocks.bases.widgets.ProfessionLvlBar;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import com.robertx22.mine_and_slash.uncommon.capability.ProfessionsCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class ProfessionGui
extends ContainerScreen<ProfessionContainer>
implements IGuiEventListener {
    Minecraft mc;
    public ProfessionTile tile;
    List<ChooseRecipeButton> displayedRecipeButtons = new ArrayList<ChooseRecipeButton>();
    List<BaseRecipe> filteredRecipes = new ArrayList<BaseRecipe>();
    ProfessionsCap.IProfessionsData proffs;
    private TextFieldWidget searchBar;
    private OnlyLvlMetCheckBox onlyLvlMetCheckbox;
    private ProfessionLvlBar lvlbar;
    int currentRow = 0;
    static int maxRowMembers = 1;
    static int maxRows = 10;
    ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/profession/villager.png");
    static int x = 318;
    static int y = 232;
    Slot currentOutput;

    public ProfessionGui(ProfessionContainer cont, PlayerInventory inv, ITextComponent text) {
        super((Container)cont, inv, text);
        TileEntity en;
        this.field_146999_f = x;
        this.field_147000_g = y;
        this.mc = Minecraft.func_71410_x();
        if (cont.pos != null && (en = Minecraft.func_71410_x().field_71441_e.func_175625_s(cont.pos)) instanceof ProfessionTile) {
            this.tile = (ProfessionTile)en;
        }
        this.proffs = Load.professions((PlayerEntity)this.mc.field_71439_g);
    }

    public boolean mouseClicked(double x, double y, int ticks) {
        this.displayedRecipeButtons.forEach(button -> button.onClick(x, y));
        this.searchBar.mouseClicked(x, y, ticks);
        this.onlyLvlMetCheckbox.mouseClicked(x, y, ticks);
        return super.mouseClicked(x, y, ticks);
    }

    public boolean keyPressed(int x, int y, int i) {
        if (!(x == 256) && this.searchBar.isFocused()) {
            return this.searchBar.keyPressed(x, y, i);
        }
        return super.keyPressed(x, y, i);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public boolean charTyped(char c, int i) {
        if (this.searchBar != null && this.searchBar.isFocused() && this.searchBar.charTyped(c, i)) {
            this.currentRow = 0;
            this.updateRecipeButtons();
            return true;
        }
        return false;
    }

    public void updateRecipeButtons() {
        this.displayedRecipeButtons.clear();
        List<BaseRecipe> recipes = this.getCurrentRecipes();
        this.filteredRecipes.clear();
        this.filteredRecipes.addAll(recipes);
        int x = this.field_147003_i + 4;
        int y = this.field_147009_r + 19;
        int xOffset = 0;
        int count = 0;
        int n = 0;
        for (int i = this.getCurrentRow() * maxRowMembers; i < recipes.size(); ++i) {
            if (++count > maxRows * maxRowMembers) {
                return;
            }
            BaseRecipe recipe = recipes.get(i);
            ItemStack output = recipe.getOutput(this.tile).getPreview();
            if (n == maxRowMembers) {
                y += ChooseRecipeButton.ySize;
                n = 0;
            }
            xOffset = n * (ChooseRecipeButton.xSize + 1);
            ChooseRecipeButton button = new ChooseRecipeButton(this.proffs.getLevel(recipe.profession()), recipe, output, x + xOffset, y, this.tile.func_174877_v());
            this.displayedRecipeButtons.add(button);
            ++n;
        }
    }

    public int getCurrentRow() {
        if (this.filteredRecipes.size() < maxRows) {
            return 0;
        }
        return MathHelper.func_76125_a((int)this.currentRow, (int)0, (int)(this.filteredRecipes.size() / maxRowMembers));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.lvlbar == null) {
            this.lvlbar = new ProfessionLvlBar(this.tile.profession, this.proffs, this.field_147003_i + 229 - ProfessionLvlBar.xSize / 2, this.field_147009_r + 70 - ProfessionLvlBar.ySize);
        }
        if (this.searchBar == null) {
            String s = this.searchBar != null ? this.searchBar.func_146179_b() : "";
            this.searchBar = new TextFieldWidget(this.mc.field_71466_p, this.field_147003_i + 20, this.field_147009_r + 5, 80, 14, I18n.func_135052_a((String)"itemGroup.search", (Object[])new Object[0]));
            this.searchBar.func_146203_f(50);
            this.searchBar.func_146185_a(false);
            this.searchBar.func_146189_e(true);
            this.searchBar.func_146193_g(0xFFFFFF);
            this.searchBar.func_146180_a(s);
        }
        if (this.onlyLvlMetCheckbox == null) {
            this.onlyLvlMetCheckbox = new OnlyLvlMetCheckBox(this.field_147003_i + this.field_146999_f - 27, this.field_147009_r + 12, 150);
        }
        if (this.onlyLvlMetCheckbox.changed) {
            this.onlyLvlMetCheckbox.changed = false;
            this.currentRow = 0;
        }
        if (this.tile != null && this.mc.field_71439_g.field_70173_aa % 10 == 0) {
            MMORPG.sendToServer(new RequestTilePacket(this.tile.func_174877_v()));
        }
        if (this.mc.field_71439_g.field_70173_aa % 5 == 0) {
            this.updateRecipeButtons();
        }
        RenderHelper.func_74518_a();
        this.renderBackground();
        RenderHelper.func_74518_a();
        super.render(mouseX, mouseY, partialTicks);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        this.renderItemIcons(mouseX, mouseY, partialTicks);
        RenderHelper.func_74518_a();
        this.onlyLvlMetCheckbox.render(mouseX, mouseY, partialTicks);
        RenderHelper.func_74518_a();
        this.searchBar.render(mouseX, mouseY, partialTicks);
        RenderHelper.func_74518_a();
        this.lvlbar.render(mouseX, mouseY, partialTicks);
        RenderHelper.func_74518_a();
        this.renderTooltips(mouseX, mouseY, partialTicks);
    }

    public void renderItemIcons(int mouseX, int mouseY, float partialTicks) {
        this.displayedRecipeButtons.forEach(x -> {
            RenderHelper.func_74518_a();
            x.render(mouseX, mouseY, partialTicks);
            RenderHelper.func_74518_a();
            this.func_146977_a((Slot)x.slot);
            x.materialSlots.forEach(slot -> {
                RenderHelper.func_74518_a();
                this.func_146977_a((Slot)slot);
            });
        });
        if (this.tile.currentRecipe != null) {
            int x2 = this.field_147003_i + 217 + 5;
            int y = this.field_147009_r + 19 + 5;
            this.currentOutput = new Slot((IInventory)new Inventory(new ItemStack[]{this.tile.currentRecipe.getOutput(this.tile).getPreview()}), 0, x2, y);
            this.func_146977_a(this.currentOutput);
        }
    }

    public void renderTooltips(int mouseX, int mouseY, float partialTicks) {
        this.func_191948_b(mouseX, mouseY);
        this.displayedRecipeButtons.forEach(button -> {
            if (button.isInsideSlot((Slot)button.slot, mouseX, mouseY)) {
                this.renderTooltip(button.slot.func_75211_c(), mouseX, mouseY);
            }
            for (RecipeSlot slot : button.materialSlots) {
                if (!button.isInsideSlot((Slot)slot, mouseX, mouseY)) continue;
                this.renderTooltip(slot.func_75211_c(), mouseX, mouseY);
            }
        });
        if (this.currentOutput != null && GuiUtils.isInRect(this.currentOutput.field_75223_e, this.currentOutput.field_75221_f, 16, 16, mouseX, mouseY)) {
            this.renderTooltip(this.currentOutput.func_75211_c(), mouseX, mouseY);
        }
    }

    public boolean mouseScrolled(double num1, double num2, double num3) {
        this.currentRow = (int)((double)this.currentRow - num3);
        this.currentRow = this.getCurrentRow();
        this.updateRecipeButtons();
        return false;
    }

    public List<BaseRecipe> getCurrentRecipes() {
        List<BaseRecipe> recipes = this.tile.profession.recipes();
        if (!this.searchBar.func_146179_b().isEmpty()) {
            ArrayList<BaseRecipe> list = new ArrayList<BaseRecipe>();
            for (BaseRecipe recipe : recipes) {
                String s = recipe.getOutput(this.tile).getPreview().func_200301_q().func_150254_d().toLowerCase();
                if (!s.contains(this.searchBar.func_146179_b().toLowerCase())) continue;
                list.add(recipe);
            }
            recipes = list;
        }
        ProfessionsCap.IProfessionsData profs = Load.professions((PlayerEntity)this.mc.field_71439_g);
        if (this.onlyLvlMetCheckbox.checked == OnlyLvlMetCheckBox.PickedRecipes.LVL_MET) {
            recipes = recipes.stream().filter(x -> x.professionLevelReq <= profs.getLevel(x.profession())).collect(Collectors.toList());
        }
        if (this.onlyLvlMetCheckbox.checked == OnlyLvlMetCheckBox.PickedRecipes.LVL_NOT_MET) {
            recipes = recipes.stream().filter(x -> x.professionLevelReq > profs.getLevel(x.profession())).collect(Collectors.toList());
        }
        if (recipes.size() > 1) {
            recipes = recipes.stream().sorted(Comparator.comparingInt(BaseRecipe::getLevelReq)).collect(Collectors.toList());
        }
        return recipes;
    }

    protected void func_146976_a(float partialTicks, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.BACKGROUND_TEXTURE);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ProfessionGui.blit((int)this.field_147003_i, (int)this.field_147009_r, (int)this.blitOffset, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)256, (int)512);
        float cooktime = this.tile.getCookTimeCompleted();
        ProfessionGui.blit((int)(this.field_147003_i + 222), (int)(this.field_147009_r + 95), (int)324, (float)324.0f, (float)0.0f, (int)16, (int)((int)(22.0f * cooktime)), (int)256, (int)512);
    }
}

