/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.professions.blocks.bases;

import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.professions.blocks.bases.ProfessionBlock;
import com.robertx22.mine_and_slash.professions.blocks.bases.ProfessionContainer;
import com.robertx22.mine_and_slash.professions.blocks.bases.Professions;
import com.robertx22.mine_and_slash.professions.recipe.BaseMaterial;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import com.robertx22.mine_and_slash.uncommon.capability.ProfessionsCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ProfessionTile
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public Professions profession = Professions.ALCHEMY;
    public BaseRecipe currentRecipe;
    public NonNullList<ItemStack> materialStacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    public NonNullList<ItemStack> outputStacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    public int playerProfLevel = 1;
    public int expEarned = 0;
    public String playerID = "";
    int ticks = 0;

    public ProfessionTile(Professions proff) {
        super(proff.tileEntityType);
        this.profession = proff;
    }

    public float getCookTimeCompleted() {
        if (!this.hasEnoughMaterials()) {
            return 0.0f;
        }
        return this.currentRecipe != null ? MathHelper.func_76131_a((float)((float)this.ticks / (float)this.currentRecipe.getCookTimeTicks()), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.func_195044_w();
            if (this.currentRecipe == null) {
                this.ticks = 0;
                this.func_70296_d();
                state = (BlockState)state.func_206870_a((IProperty)ProfessionBlock.ENABLED, (Comparable)Boolean.valueOf(false));
                this.field_145850_b.func_175656_a(this.field_174879_c, state);
            } else if (!this.hasEnoughMaterials()) {
                this.ticks = 0;
                this.func_70296_d();
                state = (BlockState)state.func_206870_a((IProperty)ProfessionBlock.ENABLED, (Comparable)Boolean.valueOf(false));
                this.field_145850_b.func_175656_a(this.field_174879_c, state);
            } else {
                ++this.ticks;
                state = (BlockState)state.func_206870_a((IProperty)ProfessionBlock.ENABLED, (Comparable)Boolean.valueOf(true));
                this.field_145850_b.func_175656_a(this.field_174879_c, state);
                if (this.ticks >= this.currentRecipe.getCookTimeTicks() && this.tryCraft()) {
                    this.expEarned += this.currentRecipe.expGiven;
                    this.ticks = 0;
                    this.func_70296_d();
                }
            }
        }
    }

    public boolean canPlayerOpen(ServerPlayerEntity player) {
        return this.playerID.isEmpty() || player.func_110124_au().toString().equals(this.playerID);
    }

    public void onOpenByPlayer(ServerPlayerEntity player) {
        ProfessionsCap.IProfessionsData cap = Load.professions((PlayerEntity)player);
        if (this.playerProfLevel > cap.getLevel(this.profession)) {
            cap.setLevel(this.profession, this.playerProfLevel);
        }
        this.playerProfLevel = cap.getLevel(this.profession);
        if (this.playerID.isEmpty()) {
            this.playerID = player.func_110124_au().toString();
        }
        if (this.expEarned > 0) {
            cap.gainExp(this.expEarned, this.profession, player);
            this.expEarned = 0;
        }
    }

    public boolean hasEnoughMaterials() {
        if (this.currentRecipe == null) {
            return false;
        }
        int i = 0;
        for (BaseMaterial mat : this.currentRecipe.getMaterials()) {
            if (!mat.isStackValidMaterial((ItemStack)this.materialStacks.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean playerMeetsLvlReq() {
        return this.playerProfLevel >= this.currentRecipe.professionLevelReq;
    }

    public boolean tryCraft() {
        if (this.currentRecipe == null) {
            return false;
        }
        if (!this.playerMeetsLvlReq()) {
            return false;
        }
        if (this.hasEnoughMaterials()) {
            ItemStack output = this.currentRecipe.getOutput(this).generateStack(this);
            output.func_190920_e(this.profession.getOutputAmount(this, this.currentRecipe.getOutput(this), this.playerProfLevel));
            if (output.func_190926_b()) {
                return false;
            }
            if (!this.canOutput(output)) {
                return false;
            }
            int i = 0;
            for (BaseMaterial mat : this.currentRecipe.getMaterials()) {
                ItemStack stack;
                if (mat.isStackValidMaterial(stack = (ItemStack)this.materialStacks.get(i))) {
                    mat.consume(stack, this);
                }
                ++i;
            }
            ItemStackHandler handler = new ItemStackHandler(this.outputStacks);
            for (int s = 0; s < handler.getSlots(); ++s) {
                if (handler.insertItem(s, output, true) != ItemStack.field_190927_a) continue;
                handler.insertItem(s, output, false);
                this.func_70296_d();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean canOutput(ItemStack stack) {
        ItemStackHandler handler = new ItemStackHandler(this.outputStacks);
        for (int s = 0; s < handler.getSlots(); ++s) {
            if (handler.insertItem(s, stack, true) != ItemStack.field_190927_a) continue;
            return true;
        }
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ProfessionContainer(i, this, this.func_174877_v(), playerInventory);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        try {
            nbt.func_218657_a("materials", (INBT)ProfessionTile.stacksToNbt(this.materialStacks, "materials"));
            nbt.func_218657_a("outputs", (INBT)ProfessionTile.stacksToNbt(this.outputStacks, "outputs"));
            if (this.currentRecipe != null) {
                nbt.func_74778_a("recipe", this.currentRecipe.GUID());
            }
            nbt.func_74768_a("exp", this.expEarned);
            nbt.func_74768_a("lvl", this.playerProfLevel);
            nbt.func_74778_a("player_id", this.playerID);
            nbt.func_74768_a("ticks", this.ticks);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        try {
            this.currentRecipe = SlashRegistry.Recipes().get(nbt.func_74779_i("recipe"));
            this.playerProfLevel = nbt.func_74762_e("lvl");
            this.expEarned = nbt.func_74762_e("exp");
            this.ticks = nbt.func_74762_e("ticks");
            this.playerID = nbt.func_74779_i("player_id");
            int NBT_TYPE_COMPOUND = 10;
            ProfessionTile.addStacksToListFromNbt(nbt.func_150295_c("materials", 10), this.materialStacks, "materials");
            ProfessionTile.addStacksToListFromNbt(nbt.func_150295_c("outputs", 10), this.outputStacks, "outputs");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT updateTag = pkt.func_148857_g();
        this.handleUpdateTag(updateTag);
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = this.func_189517_E_();
        boolean METADATA = false;
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, tag);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public static ListNBT stacksToNbt(List<ItemStack> stacks, String id) {
        ListNBT dataForAllSlots = new ListNBT();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).func_190926_b()) continue;
            CompoundNBT dataForThisSlot = new CompoundNBT();
            dataForThisSlot.func_74774_a(id, (byte)i);
            stacks.get(i).func_77955_b(dataForThisSlot);
            dataForAllSlots.add((Object)dataForThisSlot);
        }
        return dataForAllSlots;
    }

    public static void addStacksToListFromNbt(ListNBT listnbt, List<ItemStack> stacks, String id) {
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT dataForOneSlot = listnbt.func_150305_b(i);
            byte slotNumber = dataForOneSlot.func_74771_c(id);
            if (slotNumber < 0 || slotNumber >= stacks.size()) continue;
            stacks.set(slotNumber, ItemStack.func_199557_a((CompoundNBT)dataForOneSlot));
        }
    }
}

