/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.professions.blocks.bases;

import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.mmorpg.registers.common.BlockRegister;
import com.robertx22.mine_and_slash.professions.blocks.bases.ProfessionTile;
import com.robertx22.mine_and_slash.professions.recipe.BaseMaterial;
import com.robertx22.mine_and_slash.professions.recipe.BaseOutputItem;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.TextFormatting;

public enum Professions {
    ALCHEMY(Words.Alchemy, BlockRegister.ALCHEMY_TILE),
    TINKERERING(Words.Tinkering, BlockRegister.TINKERING_TILE);

    public static int MAX_LEVEL;
    public static int MAX_LEVEL_OF_RECIPES;
    public Words word;
    public TileEntityType<?> tileEntityType;

    private Professions(Words word, TileEntityType<?> tileEntityType) {
        this.tileEntityType = tileEntityType;
        this.word = word;
    }

    public List<BaseRecipe> recipes() {
        return SlashRegistry.Recipes().getFiltered(x -> x.profession().equals((Object)this));
    }

    public float getReduceMatConsumptionChance(int lvl) {
        return 20.0f / (float)MAX_LEVEL * (float)lvl;
    }

    public float getBonusOutputChance(int lvl) {
        return 20.0f / (float)MAX_LEVEL * (float)lvl;
    }

    public int getOutputAmount(ProfessionTile tile, BaseOutputItem output, int lvl) {
        float chance;
        ItemStack stack = output.generateStack(tile);
        if (stack.func_77976_d() > 1 && RandomUtils.roll(chance = this.getBonusOutputChance(lvl))) {
            return stack.func_190916_E() * 2;
        }
        return stack.func_190916_E();
    }

    public int tryReduceMaterialRequirement(ProfessionTile tile, BaseMaterial mat, int lvl) {
        float chance;
        if (mat.getItemStack().func_190916_E() > 1 && RandomUtils.roll(chance = this.getReduceMatConsumptionChance(lvl))) {
            return mat.getItemStack().func_190916_E() / 2;
        }
        return mat.getItemStack().func_190916_E();
    }

    static {
        MAX_LEVEL = 1000;
        MAX_LEVEL_OF_RECIPES = 100;
    }

    public static enum Levels {
        ONE(1, 1.0f, "Minor", TextFormatting.GRAY, 0.75f),
        TEN(10, 1.1f, "Lesser", TextFormatting.GREEN, 1.0f),
        TWENTY_FIVE(25, 1.2f, "Medium", TextFormatting.YELLOW, 1.5f),
        FIFTY(50, 1.5f, "Greater", TextFormatting.BLUE, 2.0f),
        SEVENTY_FIVE(75, 2.0f, "Major", TextFormatting.GOLD, 3.0f),
        HUNDRED(100, 3.0f, "Miraculous", TextFormatting.LIGHT_PURPLE, 5.0f);

        public TextFormatting color;
        public String name;
        public int number;
        public float materialCostMulti = 1.0f;
        public float effectMultiplier = 1.0f;

        private Levels(int num, float cost, String name, TextFormatting color, float effectMultiplier) {
            this.number = num;
            this.materialCostMulti = cost;
            this.name = name;
            this.color = color;
            this.effectMultiplier = effectMultiplier;
        }
    }
}

