/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.professions.recipe;

import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.professions.blocks.bases.ProfessionTile;
import com.robertx22.mine_and_slash.professions.blocks.bases.Professions;
import com.robertx22.mine_and_slash.professions.recipe.BaseMaterial;
import com.robertx22.mine_and_slash.professions.recipe.BaseOutputItem;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.item_classes.RecipeItemData;
import com.robertx22.mine_and_slash.uncommon.capability.ProfessionsCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Recipe;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public abstract class BaseRecipe
implements ISlashRegistryEntry {
    public String guid;
    public int professionLevelReq = 1;
    public int expGiven = 1;

    public BaseRecipe(String guid) {
        this.guid = guid;
    }

    public BaseRecipe levelReq(int lvl) {
        this.professionLevelReq = MathHelper.func_76125_a((int)lvl, (int)1, (int)100);
        return this;
    }

    public int getExpGained() {
        return this.expGiven;
    }

    public int getCookTimeTicks() {
        return 100;
    }

    public int getLevelReq() {
        return this.professionLevelReq;
    }

    public boolean meetsLvlReq(ProfessionsCap.IProfessionsData cap) {
        return cap.getLevel(this.profession()) >= this.professionLevelReq;
    }

    public abstract Professions profession();

    public abstract List<BaseMaterial> getMaterials();

    public ItemStack getPreviewRecipeStack(ProfessionTile tile) {
        ItemStack stack = this.getOutput(tile).getPreview();
        RecipeItemData data = new RecipeItemData();
        data.guid = this.guid;
        Recipe.Save(stack, data);
        return stack;
    }

    public abstract BaseOutputItem getOutput(ProfessionTile var1);

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.RECIPE;
    }

    @Override
    public String GUID() {
        return this.guid;
    }

    @Override
    public int Weight() {
        return 1000;
    }

    @Override
    public int getRarityRank() {
        return 0;
    }

    public Rarity getRarity() {
        return Rarities.Items.get(this.getRarityRank());
    }

    @Override
    public int Tier() {
        return 0;
    }
}

