/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.professions.recipe.builders;

import com.robertx22.mine_and_slash.professions.recipe.BaseMaterial;
import com.robertx22.mine_and_slash.professions.recipe.BaseOutputItem;
import com.robertx22.mine_and_slash.professions.recipe.SimpleMaterial;
import com.robertx22.mine_and_slash.professions.recipe.SimpleOutputItem;
import com.robertx22.mine_and_slash.professions.recipe.SimpleRecipe;
import net.minecraft.item.Item;

public class SimpleRecipeBuilders {

    public static class SimpleRecipeFinishBuilder {
        SimpleRecipe recipe;

        public SimpleRecipeFinishBuilder(SimpleRecipe recipe) {
            this.recipe = recipe;
        }

        public SimpleRecipe build() {
            return this.recipe;
        }
    }

    public static class SimpleRecipeExpBuilder {
        SimpleRecipe recipe;

        public SimpleRecipeExpBuilder(SimpleRecipe recipe) {
            this.recipe = recipe;
        }

        public SimpleRecipeFinishBuilder expGained(int exp) {
            this.recipe.expGiven = this.recipe.getLevelReq() == 1 ? exp * 5 : exp * this.recipe.getLevelReq();
            return new SimpleRecipeFinishBuilder(this.recipe);
        }
    }

    public static class SimpleRecipeLevelReqBuilder {
        SimpleRecipe recipe;

        public SimpleRecipeLevelReqBuilder(SimpleRecipe recipe) {
            this.recipe = recipe;
        }

        public SimpleRecipeExpBuilder levelReq(int lvl) {
            this.recipe.professionLevelReq = lvl;
            return new SimpleRecipeExpBuilder(this.recipe);
        }
    }

    public static class SimpleRecipeOuputBuilder {
        SimpleRecipe recipe;

        public SimpleRecipeOuputBuilder(SimpleRecipe recipe) {
            this.recipe = recipe;
        }

        public SimpleRecipeFinishBuilder setOutput(BaseOutputItem output) {
            this.recipe.output = output;
            return new SimpleRecipeFinishBuilder(this.recipe);
        }

        public SimpleRecipeLevelReqBuilder setOutput(Item output, int amount) {
            this.recipe.output = new SimpleOutputItem(output, this.recipe).setAmount(amount);
            return new SimpleRecipeLevelReqBuilder(this.recipe);
        }

        public SimpleRecipeLevelReqBuilder setOutput(Item output) {
            this.recipe.output = new SimpleOutputItem(output, this.recipe);
            return new SimpleRecipeLevelReqBuilder(this.recipe);
        }
    }

    public static class SimpleRecipeMatBuilder {
        SimpleRecipe recipe;

        public SimpleRecipeMatBuilder(SimpleRecipe recipe) {
            this.recipe = recipe;
        }

        public SimpleRecipeMatBuilder addMaterial(BaseMaterial mat) {
            this.recipe.materials.add(mat);
            return this;
        }

        public SimpleRecipeMatBuilder addMaterial(Item item) {
            this.recipe.materials.add(new SimpleMaterial(item));
            return this;
        }

        public SimpleRecipeMatBuilder addMaterial(Item item, int amount) {
            this.recipe.materials.add(new SimpleMaterial(item).amount(amount));
            return this;
        }

        public SimpleRecipeMatBuilder addMaterial(Item item, float amount) {
            return this.addMaterial(item, (int)amount);
        }

        public SimpleRecipeOuputBuilder buildMaterials() {
            return new SimpleRecipeOuputBuilder(this.recipe);
        }
    }
}

