/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IApplyableStats;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatTypes;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

@Storable
public class ExactStatData
implements IApplyableStats,
ITooltipList {
    @Store
    private float value = 0.0f;
    @Store
    private StatTypes type = StatTypes.Flat;
    @Store
    private String statGUID = "";

    public ExactStatData() {
    }

    public ExactStatData(ExactStatData other) {
        this.value = other.value;
        this.type = other.type;
        this.statGUID = other.statGUID;
    }

    public ExactStatData(float value, StatTypes type, String statGUID) {
        this.value = value;
        this.type = type;
        this.statGUID = statGUID;
    }

    public ExactStatData(float value, StatTypes type, Stat stat) {
        this.value = value;
        this.type = type;
        this.statGUID = stat.GUID();
    }

    public void setValue(float val) {
        this.value = val;
    }

    public float getValue() {
        return this.value;
    }

    public StatTypes getType() {
        return this.type;
    }

    public Stat getStat() {
        return SlashRegistry.Stats().get(this.statGUID);
    }

    @Override
    public void applyStats(EntityCap.UnitData data) {
        data.getUnit().getStat(this.statGUID).addExact(this.type, this.value);
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        if (this.value == 0.0f) {
            return new ArrayList<ITextComponent>();
        }
        Stat stat = this.getStat();
        TooltipStatInfo statInfo = new TooltipStatInfo(this, info);
        return new ArrayList<ITextComponent>(stat.getTooltipList(statInfo));
    }
}

