/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses;

import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.HashMap;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@Storable
public class PlayersCapBackup {
    @Store
    private HashMap<String, Integer> map = new HashMap();

    public void backup(ServerPlayerEntity player, EntityCap.UnitData data) {
        int currentLvl = data.getLevel();
        if (this.map.containsKey(this.getKey(player))) {
            int backedUpLvl = this.map.get(this.getKey(player));
            if (currentLvl > backedUpLvl) {
                this.map.put(this.getKey(player), data.getLevel());
            }
        } else {
            this.map.put(this.getKey(player), data.getLevel());
        }
    }

    public void restoreFromBackup(ServerPlayerEntity player) {
        int backedUpLvl;
        int currentLvl = Load.Unit((ICapabilityProvider)player).getLevel();
        if (currentLvl < (backedUpLvl = this.map.getOrDefault(this.getKey(player), currentLvl).intValue())) {
            Load.Unit((ICapabilityProvider)player).freelySetLevel(backedUpLvl);
            player.func_145747_a((ITextComponent)new StringTextComponent("Level Restored. If you have an error in your log file relating to the level loss, send to robertx22 (Mine and Slash)."));
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent("No need to restore level, your level is higher or equal to the backed-up level."));
        }
    }

    private String getKey(ServerPlayerEntity player) {
        return player.func_110124_au().toString();
    }
}

