/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatTypes;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.text.DecimalFormat;

@Storable
public class StatData {
    @Store
    public String Name;
    public float Flat = 0.0f;
    public float Percent = 0.0f;
    public float Multi = 0.0f;
    @Store
    public float Value = 0.0f;

    public StatData() {
    }

    public StatData(Stat stat) {
        this.Name = stat.GUID();
    }

    public Stat GetStat() {
        return SlashRegistry.Stats().get(this.Name);
    }

    public void addExact(StatTypes type, float value) {
        if (type == StatTypes.Flat) {
            this.Flat += value;
        } else if (type == StatTypes.Percent) {
            this.Percent += value;
        } else {
            this.Multi += value;
        }
    }

    public void addExact(StatData data) {
        if (data.Name.equals(this.Name)) {
            this.Flat += data.Flat;
            this.Percent += data.Percent;
            this.Multi += data.Multi;
        }
    }

    public void addFlat(float val, int lvl) {
        this.Flat = this.GetStat().ScalesToLevel() ? (this.Flat += this.GetStat().calculateScalingStatGrowth(val, lvl)) : (this.Flat += val);
    }

    public void Clear() {
        this.Flat = 0.0f;
        this.Percent = 0.0f;
        this.Multi = 0.0f;
    }

    public String formattedValue() {
        float val = this.Value;
        DecimalFormat format = new DecimalFormat();
        if (Math.abs(val) < 10.0f) {
            format.setMaximumFractionDigits(1);
            return format.format(val);
        }
        int intval = (int)val;
        return intval + "";
    }

    public float getMultiplier() {
        return 1.0f + this.Value / 100.0f;
    }
}

