/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses;

import com.robertx22.mine_and_slash.api.MineAndSlashEvents;
import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.config.dimension_configs.DimensionConfig;
import com.robertx22.mine_and_slash.config.whole_mod_entity_configs.ModEntityConfig;
import com.robertx22.mine_and_slash.database.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.types.UnknownStat;
import com.robertx22.mine_and_slash.database.stats.types.game_changers.BloodMage;
import com.robertx22.mine_and_slash.database.stats.types.resources.Energy;
import com.robertx22.mine_and_slash.database.stats.types.resources.Health;
import com.robertx22.mine_and_slash.database.stats.types.resources.MagicShield;
import com.robertx22.mine_and_slash.database.stats.types.resources.Mana;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.network.EntityUnitPacket;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.WornSetsContainerData;
import com.robertx22.mine_and_slash.saveclasses.effects.StatusEffectData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.PlayerMapCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.CommonStatUtils;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.MobStatUtils;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.PlayerStatUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.StatUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;

@Storable
public class Unit {
    @Store
    private HashMap<String, StatData> MyStats = null;
    @Store
    public WornSetsContainerData wornSets = new WornSetsContainerData();
    @Store
    public HashMap<String, StatusEffectData> statusEffects = new HashMap();
    @Store
    public String GUID = UUID.randomUUID().toString();

    @Nonnull
    public HashMap<String, StatData> getStats() {
        if (this.MyStats == null) {
            this.InitMobStats();
        }
        return this.MyStats;
    }

    @Nonnull
    public StatData getStat(Stat stat) {
        return this.getStat(stat.GUID());
    }

    @Nonnull
    public StatData getStat(String guid) {
        StatData data;
        if (this.MyStats == null) {
            this.InitMobStats();
        }
        if ((data = this.MyStats.get(guid)) == null) {
            Stat stat = SlashRegistry.Stats().get(guid);
            if (stat != null) {
                this.MyStats.put(stat.GUID(), new StatData(stat));
                return this.MyStats.get(stat.GUID());
            }
            return new StatData(new UnknownStat());
        }
        return data;
    }

    public void InitMobStats() {
        this.MyStats = new HashMap();
        for (Stat stat : SlashRegistry.Stats().getAll().values()) {
            this.MyStats.put(stat.GUID(), new StatData(stat));
        }
    }

    public void InitPlayerStats() {
        if (this.MyStats == null) {
            this.MyStats = new HashMap();
            for (Stat stat : SlashRegistry.Stats().getAll().values()) {
                this.MyStats.put(stat.GUID(), new StatData(stat));
            }
        } else {
            for (Stat stat : SlashRegistry.Stats().getAll().values()) {
                if (this.MyStats.containsKey(stat.GUID())) continue;
                this.MyStats.put(stat.GUID(), new StatData(stat));
            }
            HashMap<String, StatData> stats = new HashMap<String, StatData>(this.MyStats);
            for (Map.Entry<String, StatData> entry : stats.entrySet()) {
                if (SlashRegistry.Stats().isRegistered(entry.getKey())) continue;
                this.MyStats.remove(entry.getKey());
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Unit) {
            return ((Unit)obj).GUID == this.GUID;
        }
        return false;
    }

    public int hashCode() {
        return this.GUID.hashCode();
    }

    public Health health() {
        return (Health)this.getStat(Health.GUID).GetStat();
    }

    public Mana mana() {
        return (Mana)this.getStat(Mana.GUID).GetStat();
    }

    public Energy energy() {
        return (Energy)this.getStat(Energy.GUID).GetStat();
    }

    public float getCurrentEffectiveHealth(LivingEntity entity, EntityCap.UnitData data) {
        float curhp = this.health().CurrentValue(entity, this);
        return curhp += data.getResources().getMagicShield();
    }

    public float getMaxEffectiveHealth() {
        float hp = this.healthData().Value;
        return hp += this.magicShieldData().Value;
    }

    public boolean isBloodMage() {
        return this.getStat((Stat)BloodMage.INSTANCE).Value > 0.0f;
    }

    public float getMaximumBlood() {
        if (this.getStat((Stat)BloodMage.INSTANCE).Value > 0.0f) {
            return this.healthData().Value / 2.0f;
        }
        return 0.0f;
    }

    public StatData healthData() {
        try {
            return this.getStat(Health.GUID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public StatData magicShieldData() {
        try {
            return this.getStat(MagicShield.GUID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public StatData manaData() {
        try {
            return this.getStat(Mana.GUID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public StatData energyData() {
        try {
            return this.getStat(Energy.GUID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Unit Mob(LivingEntity entity, @Nullable PlayerEntity nearestPlayer) {
        Unit mob = new Unit();
        mob.InitMobStats();
        EntityCap.UnitData endata = Load.Unit((ICapabilityProvider)entity);
        if (nearestPlayer != null && WorldUtils.isMapWorld((IWorld)entity.field_70170_p)) {
            PlayerMapCap.IPlayerMapData mapdata = Load.playerMapData(nearestPlayer);
            endata.setTier(mapdata.getTier());
        }
        endata.SetMobLevelAtSpawn(entity, nearestPlayer);
        endata.setRarity(Unit.randomRarity(entity, endata.getLevel()));
        MobStatUtils.AddRandomMobStatusEffects(entity, mob, (MobRarity)Rarities.Mobs.get(endata.getRarity()));
        endata.setUnit(mob, entity);
        mob.RecalculateStats(entity, endata, endata.getLevel());
        return mob;
    }

    private static int randomRarity(LivingEntity entity, int level) {
        double y = entity.field_70163_u;
        int minRarity = 0;
        if (entity.field_71093_bK.equals(DimensionType.field_223227_a_)) {
            if (y < 50.0) {
                minRarity = 1;
            }
            if (y < 30.0) {
                minRarity = 2;
            }
        }
        List<MobRarity> rarities = Rarities.Mobs.rarities();
        ArrayList<MobRarity> after = new ArrayList<MobRarity>();
        DimensionConfig config = SlashRegistry.getDimensionConfig((IWorld)entity.field_70170_p);
        for (MobRarity rar : rarities) {
            if (rar.Rank() < minRarity || rar.Rank() == 4 && config.LEVEL_FOR_MOBS_TO_BE_LEGENDARY > level || rar.Rank() == 5 && config.LEVEL_FOR_MOBS_TO_BE_MYTHICAL > level) continue;
            after.add(rar);
        }
        MobRarity finalRarity = (MobRarity)RandomUtils.weightedRandom(after);
        ModEntityConfig entityconfig = SlashRegistry.getEntityConfig(entity, Load.Unit((ICapabilityProvider)entity));
        return MathHelper.func_76125_a((int)finalRarity.Rank(), (int)entityconfig.MIN_RARITY, (int)entityconfig.MAX_RARITY);
    }

    protected void ClearStats() {
        if (this.MyStats == null) {
            this.InitPlayerStats();
        }
        for (StatData stat : this.MyStats.values()) {
            stat.Clear();
        }
    }

    protected void CalcStats(EntityCap.UnitData data) {
        this.MyStats.values().forEach(stat -> stat.GetStat().CalcVal((StatData)stat, data));
    }

    private DirtyCheck getDirtyCheck() {
        if (this.MyStats == null || this.MyStats.isEmpty()) {
            this.InitPlayerStats();
        }
        DirtyCheck check = new DirtyCheck();
        check.hp = (int)this.MyStats.get((Object)Health.GUID).Value;
        return check;
    }

    private float getHpAdded(LivingEntity entity, MobRarity rar, EntityCap.UnitData data) {
        float hpadded = StatUtils.calculateNormalScalingStatGrowth(entity.func_110138_aP(), data.getLevel());
        hpadded = entity instanceof PlayerEntity ? (float)((double)hpadded * (Double)ModConfig.INSTANCE.Server.PLAYER_HEART_TO_HEALTH_CONVERSION.get()) : (hpadded *= 2.0f * rar.HealthMultiplier());
        return hpadded;
    }

    private void setAverageGearLvl(List<GearItemData> gears, EntityCap.UnitData data) {
        int total = gears.stream().mapToInt(x -> x.getLevel()).sum();
        int avg = 1;
        if (total >= 0 && gears.size() > 0) {
            avg = total / gears.size();
        }
        data.setAverageGearLevel(avg);
    }

    public void RecalculateStats(LivingEntity entity, EntityCap.UnitData data, int level) {
        DirtyCheck newcheck;
        data.setEquipsChanged(false);
        if (data.getUnit() == null) {
            data.setUnit(this, entity);
        }
        DirtyCheck old = this.getDirtyCheck();
        ArrayList<GearItemData> gears = new ArrayList<GearItemData>();
        MinecraftForge.EVENT_BUS.post((Event)new MineAndSlashEvents.CollectGearStacksEvent(entity, gears));
        this.setAverageGearLvl(gears, data);
        boolean gearIsValid = this.isGearCombinationValid(gears, (Entity)entity);
        Unit copy = this.Clone();
        PlayerMapCap.IPlayerMapData mapdata = null;
        if (entity instanceof PlayerEntity) {
            mapdata = Load.playerMapData((PlayerEntity)entity);
        }
        this.ClearStats();
        MobRarity rar = (MobRarity)Rarities.Mobs.get(data.getRarity());
        float hpadded = this.getHpAdded(entity, rar, data);
        this.MyStats.get((Object)Health.GUID).Flat += hpadded;
        Boolean isMapWorld = WorldUtils.isMapWorld((IWorld)entity.field_70170_p);
        CommonStatUtils.addPotionStats(entity, data);
        CommonStatUtils.addCustomStats(data, this, level);
        CommonStatUtils.addExactCustomStats(data);
        if (entity instanceof PlayerEntity) {
            PlayerStatUtils.AddPlayerBaseStats(data, this);
            PlayerStatUtils.addTalentStats(data, (PlayerEntity)entity);
            Load.statPoints((PlayerEntity)entity).getData().getAllStatDatas().forEach(x -> x.applyStats(data));
        } else {
            MobStatUtils.AddMobcStats(data, data.getLevel());
            MobStatUtils.worldMultiplierStats(entity.field_70170_p, this);
            if (isMapWorld.booleanValue()) {
                MobStatUtils.increaseMobStatsPerTier(data, this);
            }
            MobStatUtils.modifyMobStatsByConfig(entity, data);
        }
        if (gearIsValid) {
            PlayerStatUtils.CountWornSets((Entity)entity, gears, this);
            PlayerStatUtils.AddAllGearStats((Entity)entity, gears, data, level);
            PlayerStatUtils.AddAllSetStats((Entity)entity, data, this, level);
        }
        CommonStatUtils.AddStatusEffectStats(this, level);
        if (isMapWorld.booleanValue()) {
            CommonStatUtils.AddMapAffixStats(mapdata, this, level, entity);
        }
        CommonStatUtils.CalcStatConversionsAndTransfers(copy, this);
        CommonStatUtils.CalcTraitsAndCoreStats(data);
        MinecraftForge.EVENT_BUS.post((Event)new MineAndSlashEvents.OnStatCalculation(entity, data));
        this.CalcStats(data);
        if (entity instanceof PlayerEntity) {
            PlayerStatUtils.applyRequirementsUnmetPenalty((Entity)entity, data, gears);
        }
        if (old.isDirty(newcheck = this.getDirtyCheck())) {
            MMORPG.sendToTracking(new EntityUnitPacket((Entity)entity, data), (Entity)entity);
        }
    }

    public boolean isGearCombinationValid(List<GearItemData> gears, Entity en) {
        int unique_items = this.countUniqueItems(gears);
        if (unique_items > (Integer)ModConfig.INSTANCE.Server.MAXIMUM_WORN_UNIQUE_ITEMS.get()) {
            if (en instanceof PlayerEntity) {
                en.func_145747_a((ITextComponent)new StringTextComponent("Gear Stats Not Added, reason: you are wearing too many unique items! Maximum Possible Unique items (excluding weapon): " + ModConfig.INSTANCE.Server.MAXIMUM_WORN_UNIQUE_ITEMS.get()));
            }
            return false;
        }
        int runed_items = this.countRunedItems(gears);
        if (runed_items > (Integer)ModConfig.INSTANCE.Server.MAXIMUM_WORN_RUNED_ITEMS.get()) {
            if (en instanceof PlayerEntity) {
                en.func_145747_a((ITextComponent)new StringTextComponent("Gear Stats Not Added, reason: you are wearing too many runed items! Maximum Possible Unique items (excluding weapon): " + ModConfig.INSTANCE.Server.MAXIMUM_WORN_RUNED_ITEMS.get()));
            }
            return false;
        }
        return true;
    }

    private int countRunedItems(List<GearItemData> gears) {
        int amount = 0;
        for (GearItemData gear : gears) {
            if (!gear.isRuned()) continue;
            ++amount;
        }
        return amount;
    }

    private int countUniqueItems(List<GearItemData> gears) {
        int amount = 0;
        for (GearItemData gear : gears) {
            if (!gear.isUnique) continue;
            ++amount;
        }
        return amount;
    }

    private Unit Clone() {
        Unit clone = new Unit();
        clone.MyStats = this.MyStats != null ? new HashMap<String, StatData>(this.MyStats) : new HashMap();
        return clone;
    }

    class DirtyCheck {
        int hp;

        DirtyCheck() {
        }

        public boolean isDirty(DirtyCheck newcheck) {
            return newcheck.hp != this.hp;
        }
    }
}

