/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses;

import com.robertx22.mine_and_slash.database.sets.Set;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;

@Storable
public class WornSetData {
    @Store
    public String setGUID = "";
    @Store
    public int count = 0;
    @Store
    private List<Integer> lvls = new ArrayList<Integer>();
    @Store
    private List<String> uniqueIds = new ArrayList<String>();

    public WornSetData() {
    }

    public WornSetData(Set set) {
        this.setGUID = set.GUID();
    }

    public Set getSet() {
        return SlashRegistry.Sets().get(this.setGUID);
    }

    public List<StatMod> getSetStats() {
        return this.getSet().getObtainedMods(this);
    }

    public void addSet(GearItemData gear) {
        if (gear.set == null || gear.set.baseSet == null) {
            return;
        }
        if (gear.set.baseSet.equals(this.setGUID)) {
            if (gear.isUnique()) {
                if (this.uniqueIds.contains(gear.uniqueGUID)) {
                    return;
                }
                this.uniqueIds.add(gear.uniqueGUID);
            }
            this.lvls.add(gear.level);
            ++this.count;
        }
    }

    public int getAverageLevel() {
        int sum = this.lvls.stream().mapToInt(Integer::intValue).sum();
        if (sum > 0) {
            return sum / this.lvls.size();
        }
        return 0;
    }
}

