/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem;

import com.robertx22.mine_and_slash.database.affixes.BaseAffix;
import com.robertx22.mine_and_slash.database.affixes.Prefix;
import com.robertx22.mine_and_slash.database.requirements.GearRequestedFor;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.AffixData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ICreateSpecific;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatModsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import info.loenwind.autosave.annotations.Storable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

@Storable
public class PrefixData
extends AffixData
implements ICreateSpecific<Prefix>,
Serializable,
ITooltipList,
IRerollable {
    private static final long serialVersionUID = -110285627065158395L;

    public PrefixData() {
    }

    public PrefixData(GearItemData gear, String affixname, List<Integer> percents) {
        this.baseAffix = affixname;
        this.percents = percents;
    }

    @Override
    public void RerollFully(GearItemData gear) {
        Prefix prefix = SlashRegistry.Prefixes().getWrapped().allThatMeetRequirement(new GearRequestedFor(gear)).random();
        this.create(gear, prefix);
    }

    @Override
    public void RerollNumbers(GearItemData gear) {
        this.percents = new ArrayList();
        for (StatMod mod : this.BaseAffix().StatMods()) {
            this.percents.add(gear.getRarity().StatPercents().genPercent());
        }
    }

    @Override
    public void create(GearItemData gear, Prefix prefix) {
        this.baseAffix = prefix.GUID();
        this.RerollNumbers(gear);
    }

    @Override
    public BaseAffix BaseAffix() {
        return SlashRegistry.Prefixes().get(this.baseAffix);
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        BaseAffix affix = this.BaseAffix();
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add(Styles.GRAYCOMP().func_150257_a(Words.Prefix.locName().func_150258_a(": ").func_150257_a(affix.locName())));
        for (IStatModsContainer.LevelAndStats part : this.GetAllStats(info.level)) {
            for (StatModData data : part.mods) {
                list.addAll(data.GetTooltipString(info));
            }
        }
        return list;
    }
}

