/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem;

import com.robertx22.mine_and_slash.database.requirements.GearRequestedFor;
import com.robertx22.mine_and_slash.database.sets.Set;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.db_lists.initializers.Sets;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

@Storable
public class SetData
implements ITooltipList {
    @Store
    public String baseSet;

    public Set GetSet() {
        return SlashRegistry.Sets().get(this.baseSet);
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (this.baseSet == null || info.unitdata == null) {
            return list;
        }
        Set set = this.GetSet();
        if (set != null) {
            list.add(Styles.GREENCOMP().func_150257_a(new StringTextComponent("[Set]: ").func_150257_a(set.locName())));
            for (Map.Entry<Integer, StatMod> entry : this.GetSet().AllMods().entrySet()) {
                boolean has = false;
                TextFormatting color = null;
                if (info.unitdata.getUnit().wornSets.get((String)this.baseSet).count >= entry.getKey()) {
                    color = TextFormatting.GREEN;
                    has = true;
                } else {
                    color = TextFormatting.DARK_GREEN;
                }
                int avgLvl = info.unitdata.getUnit().wornSets.get(this.baseSet).getAverageLevel();
                TooltipInfo setInfo = info.withLevel(avgLvl).setIsSet();
                setInfo.minmax = set.statPercents;
                for (ITextComponent str : StatModData.Load(entry.getValue(), this.GetSet().StatPercent).GetTooltipString(setInfo)) {
                    ITextComponent comp = new StringTextComponent(color + "").func_150257_a((ITextComponent)new StringTextComponent("(" + entry.getKey() + ")"));
                    if (has) {
                        comp.func_150258_a(": ").func_150257_a(str);
                    } else {
                        comp.func_150258_a(": ").func_150257_a(Words.Locked.locName());
                    }
                    list.add(comp);
                }
            }
            list.add((ITextComponent)new StringTextComponent(""));
        }
        return list;
    }

    public SetData generate(GearItemData data) {
        SetData setdata = null;
        Set set = (Set)Sets.INTANCE.random(new GearRequestedFor(data));
        if (set != null) {
            setdata = new SetData();
            setdata.baseSet = set.GUID();
        }
        return setdata;
    }
}

