/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.items.unique_items.ISpecificStatReq;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

@Storable
public class StatRequirementsData {
    @Store
    private List<String> stats = new ArrayList<String>();

    private HashMap<String, Integer> getReqs(GearItemData data) {
        if (data.isUnique()) {
            try {
                return data.uniqueStats.getUniqueItem().getRequirements().getRequirements(data.level, data.getRarity());
            }
            catch (Exception e) {
                e.printStackTrace();
                return new HashMap<String, Integer>();
            }
        }
        if (data.GetBaseGearType() instanceof ISpecificStatReq) {
            ISpecificStatReq specific = (ISpecificStatReq)((Object)data.GetBaseGearType());
            return specific.getRequirements().getRequirements(data.getLevel(), data.getRarity());
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        float requirementMulti = data.getRarity().requirementMulti();
        for (String str : this.stats) {
            if (!SlashRegistry.Stats().isRegistered(str)) continue;
            map.put(str, (int)((float)(StatRequirementsData.getAmount(data) / this.stats.size()) * requirementMulti));
        }
        return map;
    }

    public void create(GearItemData data) {
        this.stats = new ArrayList<String>();
        if (data.isUnique()) {
            this.unique(data);
        } else {
            List<Stat> possibleReq = data.GetBaseGearType().statRequirements();
            if (possibleReq != null && possibleReq.size() > 0) {
                if (possibleReq.size() > 1) {
                    if (RandomUtils.roll(50)) {
                        this.doubleStat(data);
                    } else {
                        this.singleStat(data);
                    }
                } else {
                    this.singleStat(data);
                }
            }
        }
    }

    public static int getAmount(GearItemData data) {
        return StatRequirementsData.getAmount(data.getLevel());
    }

    public static int getAmount(int lvl) {
        int req = (int)((double)((float)lvl - (float)lvl / 5.0f - 5.0f) * (Double)ModConfig.INSTANCE.Server.STAT_REQUIREMENTS_MULTI.get());
        return MathHelper.func_76125_a((int)req, (int)0, (int)100000);
    }

    private void singleStat(GearItemData data) {
        List<Stat> possibleReq = data.GetBaseGearType().statRequirements();
        Stat stat = RandomUtils.weightedRandom(possibleReq);
        this.stats.add(stat.GUID());
    }

    private void doubleStat(GearItemData data) {
        List<Stat> possibleReq = data.GetBaseGearType().statRequirements();
        List<Stat> picked = RandomUtils.uniqueWightedRandoms(possibleReq, 2);
        for (Stat stat : picked) {
            this.stats.add(stat.GUID());
        }
    }

    private void unique(GearItemData data) {
    }

    public boolean meetsRequirements(EntityCap.UnitData data, GearItemData gear) {
        for (Map.Entry<String, Integer> entry : this.getReqs(gear).entrySet()) {
            if (!SlashRegistry.Stats().isRegistered(entry.getKey()) || !(data.getUnit().getStat((String)entry.getKey()).Value < (float)entry.getValue().intValue())) continue;
            return false;
        }
        return true;
    }

    public List<ITextComponent> GetTooltipString(TooltipInfo info, GearItemData gear) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        for (Map.Entry<String, Integer> entry : this.getReqs(gear).entrySet()) {
            if (entry.getValue() <= 0 || !SlashRegistry.Stats().isRegistered(entry.getKey())) continue;
            Stat stat = SlashRegistry.Stats().get(entry.getKey());
            list.add(TooltipUtils.requirement(stat.locName(), (int)info.unitdata.getUnit().getStat((Stat)stat).Value, entry.getValue()));
        }
        return list;
    }
}

