/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes;

import com.robertx22.mine_and_slash.config.ClientContainer;
import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.saveclasses.gearitem.ChaosStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.GearItemEnum;
import com.robertx22.mine_and_slash.saveclasses.gearitem.InfusionData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.PrefixData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.PrimaryStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.SecondaryStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.SetData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatRequirementsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.SuffixData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.UniqueStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatModsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearTooltipUtils;
import com.robertx22.mine_and_slash.saveclasses.item_classes.IInstability;
import com.robertx22.mine_and_slash.saveclasses.rune.RunesData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.DataItemType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ISalvagable;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Storable
public class GearItemData
implements ICommonDataItem<GearRarity>,
IInstability {
    @Store
    public StatRequirementsData requirements = null;
    @Store
    public boolean isUnique = false;
    @Store
    public String uniqueGUID = "";
    @Store
    public int Rarity;
    @Store
    public boolean isNotFromMyMod = false;
    @Store
    public String gearTypeName = "";
    @Store
    public RunesData runes;
    @Store
    public int level;
    @Store
    public UniqueStatsData uniqueStats;
    @Store
    public PrimaryStatsData primaryStats;
    @Store
    public SecondaryStatsData secondaryStats;
    @Store
    public SuffixData suffix;
    @Store
    public PrefixData prefix;
    @Store
    public SetData set;
    @Store
    public ChaosStatsData chaosStats;
    @Store
    public InfusionData infusion;
    @Store
    public boolean isSalvagable = true;
    @Store
    public int timesLeveledUp = 0;
    @Store
    public int instability = 0;

    public boolean meetsRequirements(EntityCap.UnitData data) {
        return data.getLevel() >= this.getLevel() && (this.requirements == null || this.requirements.meetsRequirements(data, this));
    }

    public boolean isRuned() {
        return this.runes != null;
    }

    public GearItemEnum getGearEnum() {
        if (this.isUnique()) {
            return GearItemEnum.UNIQUE;
        }
        if (this.isRuned()) {
            return GearItemEnum.RUNED;
        }
        return GearItemEnum.NORMAL;
    }

    public void setLevel(int lvl) {
        this.level = MathHelper.func_76125_a((int)lvl, (int)1, (int)((Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get()));
    }

    @Override
    public int getRarityRank() {
        return this.Rarity;
    }

    @Override
    public GearRarity getRarity() {
        return (GearRarity)Rarities.Items.get(this.Rarity);
    }

    public boolean changesItemStack() {
        return !this.isNotFromMyMod;
    }

    public ITextComponent name(ItemStack stack) {
        return stack.func_200301_q();
    }

    public Item getItem() {
        if (this.isUnique) {
            return (Item)SlashRegistry.UniqueGears().get(this.uniqueGUID);
        }
        if (this.gearTypeName.isEmpty()) {
            return Items.field_190931_a;
        }
        return SlashRegistry.GearTypes().get(this.gearTypeName).GetItemForRarity(this.getRarity().Rank());
    }

    public void WriteOverDataThatShouldStay(GearItemData newdata) {
        newdata.timesLeveledUp = this.timesLeveledUp;
        newdata.isSalvagable = this.isSalvagable;
    }

    public GearItemSlot GetBaseGearType() {
        return SlashRegistry.GearTypes().get(this.gearTypeName);
    }

    public int getPowerLevel() {
        int power = 0;
        for (IStatModsContainer container : this.GetAllStatContainers()) {
            for (IStatModsContainer.LevelAndStats stats : container.GetAllStats(1)) {
                for (StatModData mod : stats.mods) {
                    power += mod.getPercent();
                }
            }
        }
        return power;
    }

    public List<ITextComponent> getMergedStatsTooltip(List<IStatModsContainer.LevelAndStats> lvlstats, TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        for (IStatModsContainer.LevelAndStats part : lvlstats) {
            for (StatModData data : part.mods) {
                list.addAll(data.GetTooltipString(info.withLevel(part.level)));
            }
        }
        return list;
    }

    public ITextComponent GetDisplayName(ItemStack stack) {
        StringTextComponent text = new StringTextComponent(this.getRarity().textFormatColor() + "");
        if (this.isRuned()) {
            text.func_150257_a(Words.Runed.locName().func_150258_a(" ").func_150257_a(this.name(stack)));
        } else {
            if (this.prefix != null && this.showAffix()) {
                text.func_150257_a(this.prefix.BaseAffix().locName().func_150258_a(" "));
            }
            text.func_150257_a(this.name(stack));
            if (this.suffix != null && this.showAffix()) {
                text.func_150258_a(" ").func_150257_a(this.suffix.BaseAffix().locName()).func_150258_a(" ");
            }
        }
        return text;
    }

    private boolean showAffix() {
        return !this.isUnique() && (Boolean)ClientContainer.INSTANCE.SHOW_AFFIXED_NAME.get() != false;
    }

    public List<IStatModsContainer> GetAllStatContainers() {
        ArrayList<IStatModsContainer> list = new ArrayList<IStatModsContainer>();
        this.IfNotNullAdd(this.secondaryStats, list);
        this.IfNotNullAdd(this.primaryStats, list);
        this.IfNotNullAdd(this.prefix, list);
        this.IfNotNullAdd(this.suffix, list);
        this.IfNotNullAdd(this.chaosStats, list);
        this.IfNotNullAdd(this.uniqueStats, list);
        this.IfNotNullAdd(this.infusion, list);
        this.IfNotNullAdd(this.runes, list);
        return list;
    }

    public List<IStatModsContainer.LevelAndStats> GetAllStats(int level) {
        ArrayList<IStatModsContainer.LevelAndStats> datas = new ArrayList<IStatModsContainer.LevelAndStats>();
        for (IStatModsContainer con : this.GetAllStatContainers()) {
            datas.addAll(con.GetAllStats(this.level));
        }
        return datas;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void BuildTooltip(TooltipContext ctx) {
        GearTooltipUtils.BuildTooltip(this, ctx.stack, ctx.event, ctx.data);
    }

    public List<IRerollable> GetAllRerollable() {
        ArrayList<IRerollable> list = new ArrayList<IRerollable>();
        this.IfNotNullAdd(this.secondaryStats, list);
        this.IfNotNullAdd(this.primaryStats, list);
        this.IfNotNullAdd(this.prefix, list);
        this.IfNotNullAdd(this.suffix, list);
        this.IfNotNullAdd(this.chaosStats, list);
        this.IfNotNullAdd(this.uniqueStats, list);
        return list;
    }

    private <T> void IfNotNullAdd(T obj, List<T> list) {
        if (obj != null) {
            list.add(obj);
        }
    }

    @Override
    public ItemStack getSalvageResult(float salvageBonus) {
        if (this.isSalvagable) {
            ItemStack stack = ItemStack.field_190927_a;
            int tier = 0;
            int min = 1;
            int max = 2;
            min = this.tryIncreaseAmount(salvageBonus, min);
            max = this.tryIncreaseAmount(salvageBonus, max);
            if (this.isUnique) {
                try {
                    tier = this.uniqueStats.getUniqueItem().Tier();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.isUnique || RandomUtils.roll(this.getRarity().specialItemChance())) {
                Item item = SlashRegistry.CurrencyItems().getWrapped().ofTierRange(tier - 5, tier + 2).random();
                int tierAmountBonus = tier / 4;
                int amount = RandomUtils.RandomRange(min + tierAmountBonus, max + tierAmountBonus);
                stack = new ItemStack((IItemProvider)item);
                stack.func_190920_e(amount);
                return stack;
            }
            int amount = RandomUtils.RandomRange(min, max);
            ItemOre ore = (ItemOre)ItemOre.ItemOres.get(this.Rarity);
            stack = new ItemStack((IItemProvider)ore);
            stack.func_190920_e(amount);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public DataItemType getDataType() {
        return DataItemType.GEAR;
    }

    @Override
    public boolean isSalvagable(ISalvagable.SalvageContext context) {
        if (context == ISalvagable.SalvageContext.AUTO_SALVAGE_BAG) {
            return !this.isUnique() && this.isSalvagable;
        }
        return this.isSalvagable;
    }

    @Override
    public void saveToStack(ItemStack stack) {
        Gear.Save(stack, this);
    }

    @Override
    public String getUniqueGUID() {
        try {
            return this.uniqueStats.uniqueGUID;
        }
        catch (Exception exception) {
            return this.uniqueGUID;
        }
    }

    @Override
    public int Tier() {
        if (this.isUnique()) {
            try {
                return this.uniqueStats.getUniqueItem().Tier();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getSpecificType() {
        return this.gearTypeName;
    }

    @Override
    public int getInstability() {
        return this.instability;
    }

    @Override
    public void increaseInstability(int amount) {
        this.instability += amount;
    }
}

