/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes;

import com.robertx22.mine_and_slash.config.ClientContainer;
import com.robertx22.mine_and_slash.database.items.unique_items.IUnique;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.stats.types.resources.Energy;
import com.robertx22.mine_and_slash.database.stats.types.resources.Mana;
import com.robertx22.mine_and_slash.items.gearitems.bases.IWeapon;
import com.robertx22.mine_and_slash.items.gearitems.offhands.IEffectItem;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatModsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.MergedStats;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class GearTooltipUtils {
    public static void BuildTooltip(GearItemData gear, ItemStack stack, ItemTooltipEvent event, EntityCap.UnitData data) {
        List tip = event.getToolTip();
        TooltipInfo info = new TooltipInfo(data, gear.getRarity().StatPercents(), gear.level);
        tip.clear();
        tip.add(gear.GetDisplayName(stack));
        if (gear.primaryStats != null) {
            tip.addAll(gear.primaryStats.GetTooltipString(info));
        }
        tip.add(new StringTextComponent(""));
        ArrayList<Object> list = new ArrayList<Object>();
        tip.add(TooltipUtils.lvlReq(gear.level, data));
        if (gear.requirements != null) {
            tip.addAll(gear.requirements.GetTooltipString(info, gear));
        }
        if (gear.runes != null) {
            tip.addAll(gear.runes.GetTooltipString(info));
        }
        tip.add(new StringTextComponent(""));
        if (Screen.hasShiftDown()) {
            list.add(gear.uniqueStats);
            list.add(gear.secondaryStats);
            list.add(gear.prefix);
            list.add(gear.suffix);
            list.add(gear.infusion);
        } else {
            ArrayList<IStatModsContainer.LevelAndStats> lvlstatsmerged = new ArrayList<IStatModsContainer.LevelAndStats>();
            if (gear.uniqueStats != null) {
                tip.add(gear.uniqueStats.getHeader());
                lvlstatsmerged.addAll(gear.uniqueStats.GetAllStats(gear.level));
            }
            if (gear.secondaryStats != null) {
                lvlstatsmerged.addAll(gear.secondaryStats.GetAllStats(gear.level));
            }
            if (gear.suffix != null) {
                lvlstatsmerged.addAll(gear.suffix.GetAllStats(gear.level));
            }
            if (gear.prefix != null) {
                lvlstatsmerged.addAll(gear.prefix.GetAllStats(gear.level));
            }
            if (gear.infusion != null) {
                lvlstatsmerged.addAll(gear.infusion.GetAllStats(gear.level));
            }
            MergedStats mergedStats = new MergedStats(lvlstatsmerged, info);
            list.add(mergedStats);
        }
        list.add(gear.chaosStats);
        list.add(gear.set);
        for (ITooltipList iTooltipList : list) {
            if (iTooltipList == null) continue;
            tip.addAll(iTooltipList.GetTooltipString(info));
            tip.add(new StringTextComponent(""));
        }
        if (gear.isUnique) {
            IUnique unique = gear.uniqueStats.getUniqueItem();
            tip.add(new StringTextComponent(""));
            tip.add(TooltipUtils.tier(unique.Tier()));
            tip.add(new StringTextComponent(""));
        }
        GearRarity rarity = gear.getRarity();
        tip.add(TooltipUtils.rarity(rarity));
        if (!gear.isSalvagable) {
            tip.add(Styles.REDCOMP().func_150257_a(Words.Unsalvagable.locName()));
        }
        if (Screen.hasShiftDown() && gear.GetBaseGearType() instanceof IWeapon) {
            IWeapon iWeapon = (IWeapon)((Object)gear.GetBaseGearType());
            tip.add(new StringTextComponent(""));
            if (iWeapon.mechanic().GetEnergyCost(data.getLvlForResourceCosts()) > 0.0f) {
                tip.add(Styles.GREENCOMP().func_150257_a(Energy.INSTANCE.locName().func_150258_a(": " + (int)iWeapon.mechanic().GetEnergyCost(data.getLvlForResourceCosts()))));
            }
            if (iWeapon.mechanic().GetManaCost(data.getLvlForResourceCosts()) > 0.0f) {
                tip.add(Styles.BLUECOMP().func_150257_a(Mana.INSTANCE.locName().func_150258_a(": " + (int)iWeapon.mechanic().GetManaCost(data.getLvlForResourceCosts()))));
            }
            tip.add(new StringTextComponent(Styles.GREEN + "[Hit]: ").func_150257_a(iWeapon.mechanic().tooltipDesc()));
        }
        if (Screen.hasShiftDown()) {
            event.getToolTip().add(Styles.GOLDCOMP().func_150257_a((ITextComponent)new StringTextComponent("Power Level: " + gear.getPowerLevel())));
            if (gear.usesInstability()) {
                event.getToolTip().add(TooltipUtils.instability(gear));
            }
            event.getToolTip().add(Styles.BLUECOMP().func_150257_a((ITextComponent)new StringTextComponent("[Alt]: Show Detailed Stat Descriptions")));
        }
        if (Screen.hasShiftDown() && stack.func_77973_b() instanceof IEffectItem) {
            IEffectItem iEffectItem = (IEffectItem)stack.func_77973_b();
            event.getToolTip().addAll(iEffectItem.getEffectTooltip(Screen.hasShiftDown()));
        }
        if (gear.isUnique) {
            IUnique iUnique = gear.uniqueStats.getUniqueItem();
            List<String> lores = TooltipUtils.cutIfTooLong(CLOC.translate(iUnique.locDesc()));
            tip.add(new StringTextComponent(""));
            int i = 0;
            for (String desc : lores) {
                ITextComponent comp = Styles.GREENCOMP();
                if (i == 0) {
                    comp.func_150258_a("'");
                }
                comp.func_150258_a(desc);
                if (i == lores.size() - 1) {
                    comp.func_150258_a("'");
                }
                ++i;
                tip.add(comp);
            }
        }
        tip.add(new StringTextComponent(""));
        if (!Screen.hasShiftDown()) {
            event.getToolTip().add(Styles.BLUECOMP().func_150257_a(CLOC.tooltip("press_shift_more_info")));
        }
        List<ITextComponent> list2 = TooltipUtils.removeDoubleBlankLines(tip, (Integer)ClientContainer.INSTANCE.REMOVE_EMPTY_TOOLTIP_LINES_IF_MORE_THAN_X_LINES.get());
        tip.clear();
        tip.addAll(list2);
    }
}

