/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.rarities.MapRarity;
import com.robertx22.mine_and_slash.database.world_providers.IWP;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.bases.IBonusLootMulti;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.mapitem.MapAffixData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.Map;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AffectedEntities;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.DataItemType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityTypeUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Tooltip;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Storable
public class MapItemData
implements ICommonDataItem<MapRarity>,
IBonusLootMulti,
Cloneable {
    @Store
    public int minutes = 30;
    @Store
    public int level = 1;
    @Store
    public int tier = 0;
    @Store
    public int rarity = 0;
    @Store
    public int maxPlayersInGroup = 0;
    @Store
    public boolean groupPlay = false;
    @Store
    public boolean isPermaDeath = false;
    @Store
    public List<MapAffixData> affixes = new ArrayList<MapAffixData>();
    @Store
    public String mapUUID = UUID.randomUUID().toString();
    @Store
    public String worldGeneratorName;

    @Override
    public void saveToStack(ItemStack stack) {
        Map.Save(stack, this);
    }

    public static MapItemData empty() {
        MapItemData map = new MapItemData();
        map.mapUUID = "error";
        return map;
    }

    public MapItemData clone() {
        CompoundNBT nbt = new CompoundNBT();
        Map.Save(nbt, this);
        return Map.Load(nbt);
    }

    @Nonnull
    public IWP getIWP() {
        return SlashRegistry.WorldProviders().get(this.worldGeneratorName);
    }

    @Override
    public float getBonusLootMulti() {
        return 0.1f + 1.0f * this.getAffixMulti() * this.getPermaDeathMultiplier();
    }

    public float getPermaDeathMultiplier() {
        return this.isPermaDeath ? 1.2f : 1.0f;
    }

    public boolean increaseLevel(int i) {
        int lvl = this.level + i;
        if (lvl > (Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get()) {
            return false;
        }
        this.level = lvl;
        return true;
    }

    public boolean increaseTier(int i) {
        int tier = this.tier + i;
        if (tier > 20) {
            return false;
        }
        this.tier = tier;
        return true;
    }

    private float getAffixMulti() {
        float total = 1.0f;
        for (MapAffixData affix : this.affixes) {
            total += affix.getBonusLootMultiplier();
        }
        return total;
    }

    public static List<MapAffixData> getAllAffixesThatAffect(List<MapAffixData> affixes, LivingEntity entity) {
        AffectedEntities affected = AffectedEntities.All;
        if (entity instanceof PlayerEntity) {
            affected = AffectedEntities.Players;
        } else if (EntityTypeUtils.isMob((Entity)entity)) {
            affected = AffectedEntities.Mobs;
        }
        return MapItemData.getAllAffixesThatAffect(affixes, affected);
    }

    public static List<MapAffixData> getAllAffixesThatAffect(List<MapAffixData> affixes, AffectedEntities affected) {
        ArrayList<MapAffixData> list = new ArrayList<MapAffixData>();
        for (MapAffixData data : affixes) {
            if (!data.affectedEntities.equals((Object)affected)) continue;
            list.add(data);
        }
        return list;
    }

    @Override
    public String getUniqueGUID() {
        return this.worldGeneratorName;
    }

    public List<MapAffixData> getAllAffixesThatAffect(AffectedEntities affected) {
        ArrayList<MapAffixData> list = new ArrayList<MapAffixData>();
        for (MapAffixData data : this.affixes) {
            if (!data.affectedEntities.equals((Object)affected)) continue;
            list.add(data);
        }
        for (MapAffixData data : this.getIWP().getMapAffixes()) {
            if (!data.affectedEntities.equals((Object)affected)) continue;
            list.add(data);
        }
        return list;
    }

    public DimensionType setupPlayerMapData(World ogworld, BlockPos pos, PlayerEntity player) {
        EntityCap.UnitData unit = Load.Unit((ICapabilityProvider)player);
        ParticleUtils.spawnEnergyRestoreParticles((LivingEntity)player, 10);
        player.func_145747_a(Styles.GREENCOMP().func_150257_a(Chats.MapStarted.locName()));
        return MapManager.setupPlayerMapDimension(player, unit, this, pos);
    }

    @Override
    public ItemStack getSalvageResult(float salvageBonus) {
        int min = this.tryIncreaseAmount(salvageBonus, 1);
        int max = this.tryIncreaseAmount(salvageBonus, 3);
        ItemStack stack = ItemStack.field_190927_a;
        if (RandomUtils.roll(this.getRarity().specialItemChance())) {
            Item item = SlashRegistry.CurrencyItems().getWrapped().ofTierOrLess(this.tier).random();
            stack = new ItemStack((IItemProvider)item);
        } else {
            int amount = RandomUtils.RandomRange(min, max);
            ItemOre ore = (ItemOre)ItemOre.ItemOres.get(this.rarity);
            stack = new ItemStack((IItemProvider)ore);
            stack.func_190920_e(amount);
        }
        return stack;
    }

    @Override
    public DataItemType getDataType() {
        return DataItemType.MAP;
    }

    @Override
    public void BuildTooltip(TooltipContext ctx) {
        if (ctx.data != null) {
            List tooltip = ctx.event.getToolTip();
            GearRarity rarity = (GearRarity)Rarities.Items.get(this.rarity);
            tooltip.add(TooltipUtils.level(this.level));
            Tooltip.add("", (List<ITextComponent>)tooltip);
            MapItemData.addAffixTypeToTooltip(this, tooltip, AffectedEntities.Mobs);
            MapItemData.addAffixTypeToTooltip(this, tooltip, AffectedEntities.Players);
            MapItemData.addAffixTypeToTooltip(this, tooltip, AffectedEntities.All);
            Tooltip.add("", (List<ITextComponent>)tooltip);
            try {
                tooltip.add(Styles.BLUECOMP().func_150257_a(Words.World_Type.locName()).func_150258_a(": ").func_150257_a(this.getIWP().locName()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Tooltip.add("", (List<ITextComponent>)tooltip);
            Tooltip.add(Styles.GOLDCOMP().func_150257_a(Words.Tier.locName().func_150258_a(": " + this.tier)), (List<ITextComponent>)tooltip);
            Tooltip.add(Styles.GREENCOMP().func_150257_a(Words.Minutes.locName().func_150258_a(": " + this.minutes)), (List<ITextComponent>)tooltip);
            Tooltip.add(Styles.YELLOWCOMP().func_150257_a(Words.Bonus_Loot_Amount.locName().func_150258_a(": " + this.getBonusLootAmountInPercent() + "%")), (List<ITextComponent>)tooltip);
            Tooltip.add(TooltipUtils.rarity(rarity), (List<ITextComponent>)tooltip);
            if (this.isPermaDeath) {
                Tooltip.add(Styles.REDCOMP().func_150257_a(Words.Permadeath.locName()), (List<ITextComponent>)tooltip);
            }
            if (this.groupPlay) {
                Tooltip.add(Styles.GREENCOMP().func_150257_a(Words.GroupPlay.locName().func_150258_a(", ").func_150257_a(Words.PartySize.locName()).func_150258_a(": " + this.maxPlayersInGroup)), (List<ITextComponent>)tooltip);
            }
            Tooltip.add(Styles.BLUECOMP().func_150257_a(CLOC.tooltip("put_in_mapdevice")), (List<ITextComponent>)tooltip);
            tooltip.add(new StringTextComponent(TextFormatting.RED + "[*]").func_150257_a(Words.MapWorldsAreResetOnGameReload.locName()));
            tooltip.add(new StringTextComponent(TextFormatting.RED + "").func_150257_a(Words.DoNotBuildInMaps.locName()));
            TooltipUtils.removeDoubleBlankLines(tooltip, 20);
        }
    }

    private int getBonusLootAmountInPercent() {
        return (int)((this.getBonusLootMulti() - 1.0f) * 100.0f);
    }

    private static void addAffixTypeToTooltip(MapItemData data, List<ITextComponent> tooltip, AffectedEntities affected) {
        ArrayList<MapAffixData> affixes = new ArrayList<MapAffixData>(data.getAllAffixesThatAffect(affected));
        if (affixes.size() == 0) {
            return;
        }
        StringTextComponent str = new StringTextComponent("");
        if (affected.equals((Object)AffectedEntities.Players)) {
            str.func_150257_a(Words.Player_Affixes.locName());
        } else if (affected.equals((Object)AffectedEntities.Mobs)) {
            str.func_150257_a(Words.Mob_Affixes.locName());
        } else {
            str.func_150257_a(Words.Affixes_Affecting_All.locName());
        }
        Tooltip.add(Styles.GREENCOMP().func_150257_a((ITextComponent)str), tooltip);
        for (MapAffixData affix : affixes) {
            for (StatModData statmod : affix.getAffix().Stats(affix.percent)) {
                TooltipInfo info = new TooltipInfo(new EntityCap.DefaultImpl(), data.getRarity().StatPercents(), data.level);
                for (ITextComponent statstring : statmod.GetTooltipString(info)) {
                    Tooltip.add(statstring, tooltip);
                }
            }
        }
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
    }

    @Override
    public int getRarityRank() {
        return this.rarity;
    }

    @Override
    public MapRarity getRarity() {
        return (MapRarity)Rarities.Maps.get(this.rarity);
    }

    @Override
    public int Tier() {
        return this.tier;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getSpecificType() {
        return this.worldGeneratorName;
    }
}

