/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes;

import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.rarities.SpellRarity;
import com.robertx22.mine_and_slash.database.spells.bases.BaseSpell;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Spell;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.DataItemType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.StatUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Tooltip;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Storable
public class SpellItemData
implements ICommonDataItem {
    public static final int MIN_MANA_COST_PERCENT = 50;
    public static final int MAX_MANA_COST_PERCENT = 100;
    @Store
    public int tier = 0;
    @Store
    public int level = 1;
    @Store
    public String spellGUID;
    @Store
    public int rarity = 0;
    @Store
    public int manaCostPercent = 100;
    @Store
    public int scalingEffectPercent = 100;
    @Store
    public int baseEffectPercent = 100;
    public static float SPELL_DMG_RANDOMNESS = 1.5f;

    @Override
    public void saveToStack(ItemStack stack) {
        Spell.Save(stack, this);
    }

    @Override
    public String getUniqueGUID() {
        return this.spellGUID;
    }

    public int GetManaCost(EntityCap.UnitData data) {
        return (int)StatUtils.calculateNormalScalingStatGrowth(this.GetSpell().ManaCost() * this.manaCostPercent / 100, data.getLvlForResourceCosts());
    }

    public int GetBaseValue() {
        return (int)StatUtils.calculateNormalScalingStatGrowth(2 + this.GetSpell().BaseValue() * this.baseEffectPercent / 100, this.level);
    }

    public float GetScalingValue() {
        return this.GetSpell().ScalingValue().Multi * (float)this.scalingEffectPercent / 100.0f;
    }

    private int MinScaling() {
        return (int)(this.GetSpell().ScalingValue().Multi * (float)this.getRarity().SpellScalingPercents().Min);
    }

    private int MaxScaling() {
        return (int)(this.GetSpell().ScalingValue().Multi * (float)this.getRarity().SpellScalingPercents().Max);
    }

    private int MinBase() {
        return (int)StatUtils.calculateNormalScalingStatGrowth(1.0f + (float)this.GetSpell().BaseValue() * (float)this.getRarity().SpellBasePercents().Min / 100.0f, this.level);
    }

    private int MaxBase() {
        return (int)StatUtils.calculateNormalScalingStatGrowth(1.0f + (float)this.GetSpell().BaseValue() * (float)this.getRarity().SpellBasePercents().Max / 100.0f, this.level);
    }

    private int MinMana(EntityCap.UnitData data) {
        return (int)StatUtils.calculateNormalScalingStatGrowth(this.GetSpell().ManaCost() * 50 / 100, data.getLvlForResourceCosts());
    }

    private int MaxMana(EntityCap.UnitData data) {
        return (int)StatUtils.calculateNormalScalingStatGrowth(this.GetSpell().ManaCost() * 100 / 100, data.getLvlForResourceCosts());
    }

    @Override
    public DataItemType getDataType() {
        return DataItemType.SPELL;
    }

    @Override
    public int getRarityRank() {
        return this.rarity;
    }

    @Override
    public SpellRarity getRarity() {
        return (SpellRarity)Rarities.Spells.get(this.rarity);
    }

    public ITextComponent GetScalingDesc(boolean moreInfo) {
        StringTextComponent text = new StringTextComponent("");
        try {
            text = Words.Scaling_Value.locName().func_150258_a(": ").func_150257_a(this.GetSpell().ScalingValue().GetStat().locName()).func_150258_a(" ").func_150257_a(Words.By.locName()).func_150258_a(" : " + (int)(this.GetScalingValue() * 100.0f) + "%");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (moreInfo) {
            text.func_150258_a(" (" + this.MinScaling() + "-" + this.MaxScaling() + ")");
        }
        return text;
    }

    public ITextComponent GetBaseDesc(boolean moreInfo) {
        ITextComponent text = Words.BaseValue.locName().func_150258_a(": " + this.GetBaseValue());
        if (moreInfo) {
            text.func_150258_a(" (" + this.MinBase() + "-" + this.MaxBase() + ")");
        }
        return text;
    }

    public ITextComponent GetManaDesc(EntityCap.UnitData data, boolean moreInfo) {
        ITextComponent text = Words.Mana_Cost.locName().func_150258_a(": " + this.GetManaCost(data));
        if (moreInfo) {
            text.func_150258_a(" (" + this.MinMana(data) + "-" + this.MaxMana(data) + ")");
        }
        return text;
    }

    public int GetDamage(Unit unit) {
        int basedmg = this.GetBaseValue();
        int scalingdmg = (int)this.GetScalingValue();
        int total = basedmg + scalingdmg;
        return total;
    }

    public BaseSpell GetSpell() {
        return SlashRegistry.Spells().get(this.spellGUID);
    }

    @Override
    public ItemStack getSalvageResult(float salvageBonus) {
        int min = this.tryIncreaseAmount(salvageBonus, 1);
        int max = this.tryIncreaseAmount(salvageBonus, 2);
        ItemStack stack = ItemStack.field_190927_a;
        if (RandomUtils.roll(this.getRarity().specialItemChance())) {
            Item item = SlashRegistry.CurrencyItems().getWrapped().ofTierOrLess(this.rarity * 3).random();
            stack = new ItemStack((IItemProvider)item);
        } else {
            int amount = RandomUtils.RandomRange(min, max);
            ItemOre ore = (ItemOre)ItemOre.ItemOres.get(this.rarity);
            stack = new ItemStack((IItemProvider)ore);
            stack.func_190920_e(amount);
        }
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void BuildTooltip(TooltipContext ctx) {
        List tooltip = ctx.event.getToolTip();
        if (this.GetSpell() != null) {
            BaseSpell spell = this.GetSpell();
            GearRarity rarity = (GearRarity)Rarities.Items.get(this.rarity);
            tooltip.add(TooltipUtils.lvlReq(this.level, ctx.data));
            Tooltip.add("", (List<ITextComponent>)tooltip);
            boolean moreInfo = Screen.hasShiftDown();
            Tooltip.add(Styles.GREENCOMP().func_150257_a(Words.Stats.locName().func_150258_a(": ")), (List<ITextComponent>)tooltip);
            Tooltip.add(new StringTextComponent(TextFormatting.RED + " * ").func_150257_a(this.GetManaDesc(ctx.data, moreInfo)), (List<ITextComponent>)tooltip);
            Tooltip.add(new StringTextComponent(TextFormatting.RED + " * ").func_150257_a(this.GetBaseDesc(moreInfo)), (List<ITextComponent>)tooltip);
            if (spell.hasScalingValue()) {
                Tooltip.add(new StringTextComponent(TextFormatting.RED + " * ").func_150257_a(this.GetScalingDesc(moreInfo)), (List<ITextComponent>)tooltip);
            }
            Tooltip.add("", (List<ITextComponent>)tooltip);
            Tooltip.add(Styles.GREENCOMP().func_150257_a(Words.Use_Time.locName().func_150258_a(": " + this.GetSpell().getUseDurationInSeconds() + " sec.")), (List<ITextComponent>)tooltip);
            Tooltip.add("", (List<ITextComponent>)tooltip);
            Tooltip.add(Styles.AQUACOMP().func_150257_a(Words.Type.locName().func_150258_a(": ").func_150258_a(spell.typeString())), (List<ITextComponent>)tooltip);
            Tooltip.add("", (List<ITextComponent>)tooltip);
            Tooltip.add(Styles.LIGHT_PURPLECOMP().func_150257_a(this.GetSpell().GetDescription(this)), (List<ITextComponent>)tooltip);
            Tooltip.add("", (List<ITextComponent>)tooltip);
            tooltip.add(TooltipUtils.rarity(rarity));
        }
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int Tier() {
        return this.tier;
    }

    @Override
    public String getSpecificType() {
        return this.spellGUID;
    }
}

