/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.mapitem;

import com.robertx22.mine_and_slash.database.map_affixes.BaseMapAffix;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AffectedEntities;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.List;

@Storable
public class MapAffixData {
    @Store
    public String GUID;
    @Store
    public int percent;
    @Store
    public AffectedEntities affectedEntities;

    public MapAffixData() {
    }

    public MapAffixData(BaseMapAffix affix, int percent) {
        this.GUID = affix.GUID();
        this.percent = percent;
        this.affectedEntities = affix.isBeneficial() ? AffectedEntities.Mobs : AffectedEntities.Players;
    }

    public float getBonusLootMultiplier() {
        return (float)this.percent / 250.0f * this.getAffix().lootMulti();
    }

    public MapAffixData(String guid, int percent, AffectedEntities affects) {
        this.GUID = guid;
        this.percent = percent;
        this.affectedEntities = affects;
    }

    public BaseMapAffix getAffix() {
        return SlashRegistry.MapAffixes().get(this.GUID);
    }

    public List<StatModData> GetAllStats() {
        return this.getAffix().Stats(this.percent);
    }
}

