/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.rune;

import com.robertx22.mine_and_slash.database.rarities.RuneRarity;
import com.robertx22.mine_and_slash.database.runewords.RuneWord;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatModsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.rune.RunesData;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

@Storable
public class RuneWordData
implements IStatModsContainer,
ITooltipList {
    @Store
    public String name;
    @Store
    public int level;
    @Store
    public List<StatModData> Mods = new ArrayList<StatModData>();
    @Store
    public int rarity;

    @Override
    public List<IStatModsContainer.LevelAndStats> GetAllStats(int level) {
        return Arrays.asList(new IStatModsContainer.LevelAndStats(this.Mods, this.level));
    }

    public RuneWordData() {
    }

    public RuneWordData(RunesData data, RuneWord word) {
        this.level = data.getAverageLevel();
        int percent = data.getAveragePercents();
        this.name = word.GUID();
        this.rarity = data.getAverageRarity();
        this.Mods.clear();
        for (StatMod mod : word.mods()) {
            this.Mods.add(StatModData.Load(mod, percent));
        }
    }

    public RuneWord getRuneWord() {
        return SlashRegistry.RuneWords().get(this.name);
    }

    public RuneRarity getRarity() {
        return (RuneRarity)Rarities.Runes.get(this.rarity);
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        RuneRarity rar = this.getRarity();
        RuneWord word = this.getRuneWord();
        list.add((ITextComponent)new StringTextComponent(rar.Color() + "Rune Word: " + word.GUID().toUpperCase()));
        for (StatModData mod : this.Mods) {
            list.addAll(mod.GetTooltipString(info));
        }
        return list;
    }
}

