/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.rune;

import com.robertx22.mine_and_slash.database.runewords.RuneWord;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatModsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.RuneItemData;
import com.robertx22.mine_and_slash.saveclasses.rune.InsertedRuneData;
import com.robertx22.mine_and_slash.saveclasses.rune.RuneWordData;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

@Storable
public class RunesData
implements ITooltipList,
IStatModsContainer {
    @Store
    public List<InsertedRuneData> runes = new ArrayList<InsertedRuneData>();
    @Store
    public List<RuneWordData> runewords = new ArrayList<RuneWordData>();
    @Store
    public int capacity = 1;

    public boolean hasSpace() {
        return this.runes.size() < this.capacity;
    }

    @Override
    public List<IStatModsContainer.LevelAndStats> GetAllStats(int level) {
        ArrayList<IStatModsContainer.LevelAndStats> list = new ArrayList<IStatModsContainer.LevelAndStats>();
        for (InsertedRuneData rune : this.runes) {
            list.addAll(rune.GetAllStats(level));
        }
        for (RuneWordData word : this.runewords) {
            list.addAll(word.GetAllStats(level));
        }
        return list;
    }

    public String getRemainingRuneWordCombo() {
        String text = "";
        for (InsertedRuneData item : this.runes) {
            if (item.usedForRuneWord.length() != 0) continue;
            text = text + item.rune.toUpperCase();
        }
        return text;
    }

    public void insert(RuneItemData rune, GearItemData gear) {
        this.runes.add(new InsertedRuneData(rune.level, rune.name, Arrays.asList(rune.getModFor(gear)), rune.rarity));
    }

    public boolean canAwakenRuneWord(RuneWord word) {
        String text = "";
        block0: for (int i = 0; i < word.size(); ++i) {
            for (InsertedRuneData inserted : this.runes) {
                if (!inserted.isNotUsedByAnyRuneWord() || !inserted.rune.equals(word.runes().get(i).GUID())) continue;
                text = text + word.runes().get(i).name();
                continue block0;
            }
        }
        String wordToAwaken = word.getRuneWordCombo().toUpperCase();
        return text.toUpperCase().equals(wordToAwaken);
    }

    public boolean AwakenRuneWord(String word) {
        RuneWord runeword = SlashRegistry.RuneWords().get(word);
        if (runeword != null) {
            this.runewords.add(new RuneWordData(this, runeword));
            block0: for (int i = 0; i < runeword.size(); ++i) {
                for (InsertedRuneData inserted : this.runes) {
                    if (inserted.usedForRuneWord.length() != 0 || !inserted.rune.equals(runeword.runes().get(i).name())) continue;
                    inserted.usedForRuneWord = runeword.GUID();
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    public int getAveragePercents() {
        int per = 0;
        for (InsertedRuneData rune : this.runes) {
            per += rune.getAveragePercents();
        }
        return per /= this.runes.size();
    }

    public int getAverageLevel() {
        int per = 0;
        for (InsertedRuneData rune : this.runes) {
            per += rune.level;
        }
        return per /= this.runes.size();
    }

    public int getAverageRarity() {
        int avg = this.getAveragePercents();
        if (avg > 90) {
            return 5;
        }
        if (avg > 80) {
            return 4;
        }
        if (avg > 65) {
            return 3;
        }
        if (avg > 50) {
            return 2;
        }
        if (avg > 30) {
            return 1;
        }
        return 0;
    }

    public boolean canFit(GearItemData gear, RuneItemData rune) {
        return this.hasSpace() && gear.level >= rune.level && !this.alreadyContains(rune);
    }

    public boolean alreadyContains(RuneItemData rune) {
        for (InsertedRuneData r : this.runes) {
            if (!r.rune.equals(rune.name)) continue;
            return true;
        }
        return false;
    }

    public void clearRunes() {
        this.runes.clear();
        this.runewords.clear();
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent(""));
        list.add(Styles.GRAYCOMP().func_150257_a((ITextComponent)new StringTextComponent("Runes: ")));
        for (InsertedRuneData rune : this.runes) {
            list.addAll(rune.GetTooltipString(info));
        }
        int empty = this.capacity - this.runes.size();
        for (int i = 0; i < empty; ++i) {
            list.add(Styles.GRAYCOMP().func_150257_a((ITextComponent)new StringTextComponent("Rune: [Empty ]")));
        }
        list.add((ITextComponent)new StringTextComponent(""));
        if (this.runewords != null && this.runewords.size() > 0) {
            for (RuneWordData word : this.runewords) {
                list.addAll(word.GetTooltipString(info));
            }
        }
        return list;
    }
}

