/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.talents;

import com.robertx22.mine_and_slash.database.talent_tree.Perk;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IApplyableStats;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Storable
public class PlayerTalentsData
implements IApplyableStats {
    @Store
    public int resetPoints = 0;
    @Store
    private HashMap<String, Boolean> map = new HashMap();

    public boolean isAllocated(String guid) {
        return this.map.getOrDefault(guid, false);
    }

    public boolean isAllocated(Perk point) {
        return this.isAllocated(point.GUID());
    }

    public void allocate(String guid) {
        this.map.put(guid, true);
    }

    public void remove(String guid) {
        this.map.put(guid, false);
    }

    public int getAllocatedTalents() {
        int talents = 0;
        for (Map.Entry<String, Boolean> entry : this.map.entrySet()) {
            if (!entry.getValue().booleanValue() || !SlashRegistry.Perks().isRegistered(entry.getKey())) continue;
            ++talents;
        }
        return talents;
    }

    public void reset() {
        this.map.clear();
    }

    public boolean canRemove(Perk toRemove) {
        if (!this.isAllocated(toRemove)) {
            return false;
        }
        if (this.resetPoints <= 0) {
            return false;
        }
        for (Perk perk : toRemove.connections) {
            if (!this.isAllocated(perk) || this.hasPathToStart(perk, toRemove)) continue;
            return false;
        }
        return true;
    }

    private boolean hasPathToStart(Perk check, Perk toRemove) {
        ArrayDeque<Perk> openSet = new ArrayDeque<Perk>();
        openSet.addAll(check.connections);
        HashSet<Perk> closedSet = new HashSet<Perk>();
        while (!openSet.isEmpty()) {
            Perk current = (Perk)openSet.poll();
            if (current == toRemove || !this.isAllocated(current)) continue;
            if (current.isStart) {
                return true;
            }
            if (!closedSet.add(current)) continue;
            openSet.addAll(current.connections);
        }
        return false;
    }

    public List<Perk> getAllCurrentTalents() {
        ArrayList<Perk> list = new ArrayList<Perk>();
        for (Map.Entry<String, Boolean> entry : this.map.entrySet()) {
            Perk perk;
            if (!entry.getValue().booleanValue() || (perk = SlashRegistry.Perks().get(entry.getKey())) == null) continue;
            list.add(perk);
        }
        return list;
    }

    @Override
    public void applyStats(EntityCap.UnitData data) {
        for (Perk talent : this.getAllCurrentTalents()) {
            if (talent.effect == null) continue;
            talent.effect.applyStats(data);
        }
    }
}

