/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability;

import com.robertx22.mine_and_slash.api.MineAndSlashEvents;
import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.config.whole_mod_entity_configs.ModEntityConfig;
import com.robertx22.mine_and_slash.database.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.stats.types.misc.BonusExp;
import com.robertx22.mine_and_slash.database.stats.types.offense.PhysicalDamage;
import com.robertx22.mine_and_slash.database.stats.types.resources.Energy;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.items.gearitems.bases.IWeapon;
import com.robertx22.mine_and_slash.items.gearitems.bases.WeaponMechanic;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.mmorpg.registers.common.CriteriaRegisters;
import com.robertx22.mine_and_slash.network.EntityUnitPacket;
import com.robertx22.mine_and_slash.network.sync_cap.CapTypes;
import com.robertx22.mine_and_slash.network.sync_cap.SyncCapabilityToClient;
import com.robertx22.mine_and_slash.onevent.player.OnLogin;
import com.robertx22.mine_and_slash.saveclasses.CustomExactStatsData;
import com.robertx22.mine_and_slash.saveclasses.CustomStatsData;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseProvider;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseStorage;
import com.robertx22.mine_and_slash.uncommon.capability.bases.ICommonCapability;
import com.robertx22.mine_and_slash.uncommon.datasaving.CustomExactStats;
import com.robertx22.mine_and_slash.uncommon.datasaving.CustomStats;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.UnitNbt;
import com.robertx22.mine_and_slash.uncommon.datasaving.base.LoadSave;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AttackUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityTypeUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityCap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "entitydata");
    @CapabilityInject(value=UnitData.class)
    public static final Capability<UnitData> Data = null;
    private static final String LEVEL = "level";
    private static final String RARITY = "rarity";
    private static final String EXP = "exp";
    private static final String UUID = "uuid";
    private static final String MOB_SAVED_ONCE = "mob_saved_once";
    private static final String CURRENT_MAP_ID = "current_map_resource_loc";
    private static final String SET_MOB_STATS = "set_mob_stats";
    private static final String NEWBIE_STATUS = "is_a_newbie";
    private static final String DMG_DONE_BY_NON_PLAYERS = "DMG_DONE_BY_NON_PLAYERS";
    private static final String EQUIPS_CHANGED = "EQUIPS_CHANGED";
    private static final String TIER = "TIER";
    private static final String PREVENT_LOOT = "PREVENT_LOOT";
    private static final String SHOULD_SYNC = "SHOULD_SYNC";
    private static final String ENTITY_TYPE = "ENTITY_TYPE";
    private static final String RESOURCES_LOC = "RESOURCES_LOC";
    private static final String AVG_GEAR_LVL = "AVG_GEAR_LVL";

    public static class Storage
    extends BaseStorage<UnitData> {
    }

    public static class DefaultImpl
    implements UnitData {
        boolean setMobStats = false;
        Unit unit = null;
        int level = 1;
        int exp = 0;
        int rarity = 0;
        String uuid = "";
        String currentMapResourceLoc = "";
        boolean isNewbie = true;
        boolean equipsChanged = true;
        int tier = 0;
        boolean preventLoot = false;
        boolean shouldSync = false;
        EntityTypeUtils.EntityType type = EntityTypeUtils.EntityType.PLAYER;
        int averageGearLevel = 1;
        float dmgByNonPlayers = 0.0f;
        ResourcesData resources = new ResourcesData();
        CustomStatsData customStats = new CustomStatsData();
        CustomExactStatsData customExactStats = new CustomExactStatsData();

        @Override
        public CompoundNBT getNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74776_a(EntityCap.DMG_DONE_BY_NON_PLAYERS, this.dmgByNonPlayers);
            nbt.func_74768_a(EntityCap.LEVEL, this.level);
            nbt.func_74768_a(EntityCap.EXP, this.exp);
            nbt.func_74768_a(EntityCap.RARITY, this.rarity);
            nbt.func_74768_a(EntityCap.AVG_GEAR_LVL, this.averageGearLevel);
            nbt.func_74768_a(EntityCap.TIER, this.tier);
            nbt.func_74778_a(EntityCap.UUID, this.uuid);
            nbt.func_74757_a(EntityCap.MOB_SAVED_ONCE, true);
            nbt.func_74778_a(EntityCap.CURRENT_MAP_ID, this.currentMapResourceLoc);
            nbt.func_74757_a(EntityCap.SET_MOB_STATS, this.setMobStats);
            nbt.func_74757_a(EntityCap.NEWBIE_STATUS, this.isNewbie);
            nbt.func_74757_a(EntityCap.EQUIPS_CHANGED, this.equipsChanged);
            nbt.func_74757_a(EntityCap.PREVENT_LOOT, this.preventLoot);
            nbt.func_74757_a(EntityCap.SHOULD_SYNC, this.shouldSync);
            nbt.func_74778_a(EntityCap.ENTITY_TYPE, this.type.toString());
            if (this.customStats != null) {
                CustomStats.Save(nbt, this.customStats);
            }
            if (this.customExactStats != null) {
                CustomExactStats.Save(nbt, this.customExactStats);
            }
            if (this.unit != null) {
                UnitNbt.Save(nbt, this.unit);
            }
            if (this.resources != null) {
                LoadSave.Save(this.resources, nbt, EntityCap.RESOURCES_LOC);
            }
            return nbt;
        }

        @Override
        public void setNBT(CompoundNBT nbt) {
            this.level = nbt.func_74762_e(EntityCap.LEVEL);
            this.exp = nbt.func_74762_e(EntityCap.EXP);
            this.rarity = nbt.func_74762_e(EntityCap.RARITY);
            this.tier = nbt.func_74762_e(EntityCap.TIER);
            this.averageGearLevel = nbt.func_74762_e(EntityCap.AVG_GEAR_LVL);
            this.uuid = nbt.func_74779_i(EntityCap.UUID);
            this.dmgByNonPlayers = nbt.func_74760_g(EntityCap.DMG_DONE_BY_NON_PLAYERS);
            this.currentMapResourceLoc = nbt.func_74779_i(EntityCap.CURRENT_MAP_ID);
            this.setMobStats = nbt.func_74767_n(EntityCap.SET_MOB_STATS);
            this.isNewbie = nbt.func_74767_n(EntityCap.NEWBIE_STATUS);
            this.equipsChanged = nbt.func_74767_n(EntityCap.EQUIPS_CHANGED);
            this.preventLoot = nbt.func_74767_n(EntityCap.PREVENT_LOOT);
            this.shouldSync = nbt.func_74767_n(EntityCap.SHOULD_SYNC);
            try {
                this.resources = LoadSave.Load(ResourcesData.class, new ResourcesData(), nbt, EntityCap.RESOURCES_LOC);
                if (this.resources == null) {
                    this.resources = new ResourcesData();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                String typestring = nbt.func_74779_i(EntityCap.ENTITY_TYPE);
                this.type = EntityTypeUtils.EntityType.valueOf(typestring);
            }
            catch (Exception e) {
                this.type = EntityTypeUtils.EntityType.OTHER;
            }
            this.customStats = CustomStats.Load(nbt);
            if (this.customStats == null) {
                this.customStats = new CustomStatsData();
            }
            this.customExactStats = CustomExactStats.Load(nbt);
            if (this.customExactStats == null) {
                this.customExactStats = new CustomExactStatsData();
            }
            this.unit = UnitNbt.Load(nbt);
            if (this.unit == null) {
                this.unit = new Unit();
            }
        }

        @Override
        public void mobBasicAttack(LivingHurtEvent event, LivingEntity source, LivingEntity target, UnitData sourcedata, UnitData targetdata, float event_damage) {
            MobRarity rar = (MobRarity)Rarities.Mobs.get(sourcedata.getRarity());
            float vanilla = event_damage * (float)sourcedata.getLevel() * sourcedata.getDMGMultiplierIncreaseByTier();
            float num = 1.1f * vanilla * rar.DamageMultiplier();
            num = (float)((double)num * SlashRegistry.getEntityConfig((LivingEntity)source, (UnitData)sourcedata).DMG_MULTI);
            DamageEffect dmg = new DamageEffect(event, source, target, (int)num, sourcedata, targetdata, EffectData.EffectTypes.BASIC_ATTACK, WeaponTypes.None);
            dmg.Activate();
        }

        @Override
        public int GetExpRequiredForLevelUp() {
            return DefaultImpl.levelToExp(this.getLevel() + 1);
        }

        public static void testEXPLevelingCurve() {
            int i;
            System.out.println("Old Formula");
            for (i = 1; i < 101; ++i) {
            }
            System.out.println("New Formula");
            for (i = 1; i < 101; ++i) {
                System.out.println("level: " + i + " exp: " + DefaultImpl.levelToExp(i));
            }
        }

        public static int equateXp(double xp) {
            return (int)Math.floor(xp + 340.0 * Math.pow(2.0, xp / 9.0));
        }

        public static int levelToExp(int level) {
            double xp = 0.0;
            for (int i = 1; i < level; ++i) {
                xp += (double)DefaultImpl.equateXp(i);
            }
            return (int)Math.floor(xp / 4.0);
        }

        @Override
        public void SetMobLevelAtSpawn(LivingEntity entity, PlayerEntity player) {
            this.setMobStats = true;
            if (WorldUtils.isMapWorldClass((IWorld)entity.field_70170_p)) {
                if (player != null) {
                    this.level = Load.playerMapData(player).getLevel();
                } else {
                    this.setMobLvlNormally(entity);
                }
            } else {
                this.setMobLvlNormally(entity);
            }
        }

        private void setMobLvlNormally(LivingEntity entity) {
            ModEntityConfig entityConfig = SlashRegistry.getEntityConfig(entity, this);
            int lvl = LevelUtils.determineLevel(entity.field_70170_p, entity.func_180425_c()) + entityConfig.LEVEL_MODIFIER;
            this.level = MathHelper.func_76125_a((int)lvl, (int)entityConfig.MIN_LEVEL, (int)entityConfig.MAX_LEVEL);
        }

        @Override
        public void setEquipsChanged(boolean bool) {
            this.equipsChanged = bool;
        }

        @Override
        public void onDamagedByNonPlayer(LivingEntity entity, float dmg) {
            this.dmgByNonPlayers += dmg;
            if (!this.preventLoot && !this.shouldDropLoot(entity)) {
                this.preventLoot = true;
                this.shouldSync = true;
            }
        }

        @Override
        public boolean shouldDropLoot() {
            return !this.preventLoot;
        }

        private boolean shouldDropLoot(LivingEntity entity) {
            return (double)entity.func_110138_aP() * (Double)ModConfig.INSTANCE.Server.STOP_DROPS_IF_NON_PLAYER_DOES_DMG_PERCENT.get() >= (double)this.dmgByNonPlayers;
        }

        @Override
        public int PostGiveExpEvent(LivingEntity killed, PlayerEntity player, int i) {
            i = (int)((double)i * (Double)ModConfig.INSTANCE.Server.EXPERIENCE_MULTIPLIER.get());
            i = (int)((double)i * ((double)this.getUnit().getStat((String)BonusExp.GUID).Value / 100.0 + 1.0));
            MinecraftForge.EVENT_BUS.post((Event)new MineAndSlashEvents.GiveExpEvent(killed, player, this, i));
            return i;
        }

        @Override
        public int GiveExp(PlayerEntity player, int i) {
            this.setExp(this.exp + i);
            if (this.exp > this.GetExpRequiredForLevelUp()) {
                if (!((Boolean)ModConfig.INSTANCE.Server.LEVEL_UPS_COST_TOKEN.get()).booleanValue() && this.CheckIfCanLevelUp() && this.CheckLevelCap()) {
                    this.LevelUp(player);
                }
                return i;
            }
            return i;
        }

        @Override
        public boolean CheckIfCanLevelUp() {
            return this.getExp() >= this.GetExpRequiredForLevelUp();
        }

        public int getRemainingExp() {
            int num = this.getExp() - this.GetExpRequiredForLevelUp();
            if (num < 0) {
                num = 0;
            }
            return num;
        }

        @Override
        public boolean CheckLevelCap() {
            return this.getLevel() + 1 <= (Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get();
        }

        @Override
        public boolean LevelUp(PlayerEntity player) {
            if (!this.CheckIfCanLevelUp()) {
                player.func_145747_a(Chats.Not_enough_experience.locName());
            } else if (!this.CheckLevelCap()) {
                player.func_145747_a(Chats.Can_not_go_over_maximum_level.locName());
            }
            if (this.CheckIfCanLevelUp() && this.CheckLevelCap()) {
                this.setLevel(this.level + 1, (LivingEntity)player);
                this.setExp(this.getRemainingExp());
                player.func_145747_a(new StringTextComponent(TextFormatting.YELLOW + "" + TextFormatting.BOLD).func_150257_a(Chats.You_have_leveled_up.locName()).func_150258_a("!"));
                CriteriaRegisters.PLAYER_LEVEL_TRIGGER.trigger((ServerPlayerEntity)player, this);
                this.onLvlPostStatPickMsg((LivingEntity)player);
                this.onLvlPostTalentsMsg((LivingEntity)player);
                try {
                    Load.playersCapBackup(MapManager.getWorld(DimensionType.field_223227_a_)).getBackup().backup((ServerPlayerEntity)player, this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        public void onLvlPostTalentsMsg(LivingEntity en) {
            int points = Load.talents((PlayerEntity)en).getFreePoints(this);
            if (points > 0) {
                StringTextComponent msg = new StringTextComponent(TextFormatting.BLUE + "You have " + points + " Unspent Talent points." + TextFormatting.ITALIC + " Click to Open Talents");
                msg.func_150255_a(msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/opentalentsgui")));
                en.func_145747_a((ITextComponent)msg);
            }
        }

        public void onLvlPostStatPickMsg(LivingEntity en) {
            int points = Load.statPoints((PlayerEntity)en).getAvailablePoints(this);
            if (points > 0) {
                StringTextComponent msg = new StringTextComponent(TextFormatting.GREEN + "You have " + points + " Unspent Stat points." + TextFormatting.ITALIC + " Click to Open Gui");
                msg.func_150255_a(msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/openpickstatsgui")));
                en.func_145747_a((ITextComponent)msg);
            }
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public void setLevel(int lvl, LivingEntity entity) {
            this.level = MathHelper.func_76125_a((int)lvl, (int)1, (int)((Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get()));
            this.equipsChanged = true;
            this.shouldSync = true;
            if (entity instanceof ServerPlayerEntity) {
                CriteriaRegisters.PLAYER_LEVEL_TRIGGER.trigger((ServerPlayerEntity)entity, this);
            }
        }

        @Override
        public int getExp() {
            return this.exp;
        }

        @Override
        public void setExp(int exp) {
            this.exp = exp;
        }

        @Override
        public void onAttackEntity(LivingEntity attacker, LivingEntity victim) {
        }

        @Override
        public void modifyResource(ResourcesData.Context ctx) {
            this.resources.modify(ctx);
        }

        @Override
        public void onDeath(LivingEntity en) {
            int expLoss = (int)((double)this.exp * (Double)ModConfig.INSTANCE.Server.XP_LOSS_ON_DEATH.get());
            if (expLoss > 0) {
                this.exp = MathHelper.func_76125_a((int)(this.exp - expLoss), (int)0, (int)Integer.MAX_VALUE);
            }
        }

        @Override
        public void setType(LivingEntity en) {
            this.type = EntityTypeUtils.getType(en);
        }

        @Override
        public EntityTypeUtils.EntityType getType() {
            return this.type;
        }

        @Override
        public void trySync(LivingEntity entity) {
            if (this.shouldSync) {
                this.shouldSync = false;
                MMORPG.sendToTracking(new EntityUnitPacket((Entity)entity), (Entity)entity);
            }
        }

        @Override
        public void syncToClient(PlayerEntity player) {
            if (this.unit != null) {
                ServerPlayerEntity mp = (ServerPlayerEntity)player;
                SyncCapabilityToClient packet = new SyncCapabilityToClient(mp, CapTypes.ENTITY_DATA);
                MMORPG.sendToClient(packet, mp);
            }
        }

        @Override
        public Unit getUnit() {
            return this.unit;
        }

        @Override
        public void setUnit(Unit unit, LivingEntity entity) {
            this.unit = unit;
        }

        @Override
        public void setRarity(int rarity) {
            this.rarity = rarity;
            this.equipsChanged = true;
        }

        @Override
        public int getRarity() {
            return this.rarity;
        }

        @Override
        public String getUUID() {
            return this.uuid;
        }

        @Override
        public void setUUID(UUID id) {
            this.uuid = id.toString();
        }

        @Override
        public ITextComponent getName(LivingEntity entity) {
            if (entity instanceof PlayerEntity) {
                return new StringTextComponent("[Lv:").func_150258_a(this.getLevel() + "]  ").func_150257_a(entity.func_145748_c_());
            }
            MobRarity rarity = (MobRarity)Rarities.Mobs.get(this.getRarity());
            ITextComponent rarityprefix = rarity.locName();
            ITextComponent name = entity.func_145748_c_();
            ITextComponent lvlcomp = Styles.YELLOWCOMP().func_150257_a((ITextComponent)new StringTextComponent("[Lv:" + this.getLevel() + "] "));
            ITextComponent suffix = new StringTextComponent(rarity.textFormatColor() + "").func_150257_a(rarityprefix.func_150258_a(" ").func_150257_a(name));
            return lvlcomp.func_150257_a(suffix);
        }

        @Override
        public void HandleCloneEvent(UnitData old) {
            this.setNBT(old.getNBT());
        }

        @Override
        public void recalculateStats(LivingEntity entity) {
            if (this.unit == null) {
                this.unit = new Unit();
            }
            if (this.needsToRecalcStats()) {
                this.unit.RecalculateStats(entity, this, this.level);
            }
        }

        @Override
        public void forceRecalculateStats(LivingEntity entity) {
            if (this.unit == null) {
                this.unit = new Unit();
            }
            this.unit.RecalculateStats(entity, this, this.level);
        }

        private boolean needsToRecalcStats() {
            return this.equipsChanged;
        }

        @Override
        public void forceSetUnit(Unit unit) {
            this.unit = unit;
        }

        @Override
        public GearItemData getWeaponData(LivingEntity entity) {
            return Gear.Load(entity.func_184614_ca());
        }

        @Override
        public boolean tryUseWeapon(GearItemData weaponData, LivingEntity source) {
            return this.tryUseWeapon(weaponData, source, 1.0f);
        }

        @Override
        public boolean tryUseWeapon(GearItemData weaponData, LivingEntity source, float multi) {
            try {
                if (weaponData != null && weaponData.GetBaseGearType() instanceof IWeapon) {
                    IWeapon iwep = (IWeapon)((Object)weaponData.GetBaseGearType());
                    float energyCost = iwep.mechanic().GetEnergyCost(this.getLvlForResourceCosts()) * multi;
                    float manaCost = iwep.mechanic().GetManaCost(this.getLvlForResourceCosts()) * multi;
                    ResourcesData.Context ene = new ResourcesData.Context(this, source, ResourcesData.Type.ENERGY, energyCost, ResourcesData.Use.SPEND);
                    ResourcesData.Context mana = new ResourcesData.Context(this, source, ResourcesData.Type.MANA, manaCost, ResourcesData.Use.SPEND);
                    if (!this.getResources().hasEnough(ene)) {
                        AttackUtils.NoEnergyMessage((Entity)source);
                        return false;
                    }
                    if (!this.getResources().hasEnough(mana)) {
                        AttackUtils.NoEnergyMessage((Entity)source);
                        return false;
                    }
                    this.getResources().modify(ene);
                    this.getResources().modify(mana);
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        public void attackWithWeapon(LivingHurtEvent event, ItemStack weapon, GearItemData weaponData, LivingEntity source, LivingEntity target, UnitData targetdata) {
            if (weaponData.GetBaseGearType() instanceof IWeapon) {
                if (weapon != null) {
                    weapon.func_96631_a(1, new Random(), null);
                }
                IWeapon iwep = (IWeapon)((Object)weaponData.GetBaseGearType());
                WeaponMechanic iWep = iwep.mechanic();
                iWep.Attack(event, source, target, this, targetdata);
            }
        }

        @Override
        public void onLogin(PlayerEntity player) {
            try {
                if (this.unit == null) {
                    this.unit = new Unit();
                }
                this.unit.InitPlayerStats();
                if (this.isNewbie()) {
                    this.setNewbieStatus(false);
                    if (((Boolean)ModConfig.INSTANCE.Server.GET_STARTER_ITEMS.get()).booleanValue()) {
                        OnLogin.GiveStarterItems(player);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean increaseRarity(LivingEntity entity) {
            if (this.rarity == 5) {
                return false;
            }
            ++this.rarity;
            this.shouldSync = true;
            return true;
        }

        @Override
        public boolean decreaseRarity(LivingEntity entity) {
            if (this.rarity - 1 < 0) {
                return false;
            }
            --this.rarity;
            this.shouldSync = true;
            return true;
        }

        @Override
        public String getCurrentMapId() {
            return this.currentMapResourceLoc;
        }

        @Override
        public void setCurrentMapId(String id) {
            this.currentMapResourceLoc = id;
        }

        @Override
        public boolean hasCurrentMapId() {
            return !this.currentMapResourceLoc.isEmpty();
        }

        @Override
        public void clearCurrentMapId() {
            this.currentMapResourceLoc = "";
        }

        @Override
        public void unarmedAttack(LivingHurtEvent event, LivingEntity source, LivingEntity target, UnitData targetdata) {
            float cost = ((Double)ModConfig.INSTANCE.Server.UNARMED_ENERGY_COST.get()).floatValue();
            cost = Energy.INSTANCE.calculateScalingStatGrowth(cost, this.getLvlForResourceCosts());
            ResourcesData.Context energy = new ResourcesData.Context(this, source, ResourcesData.Type.ENERGY, cost, ResourcesData.Use.SPEND);
            if (this.getResources().hasEnough(energy)) {
                this.getResources().modify(energy);
                int num = (int)this.unit.getStat((String)PhysicalDamage.GUID).Value;
                DamageEffect dmg = new DamageEffect(event, source, target, num, this, targetdata, EffectData.EffectTypes.NORMAL, WeaponTypes.None);
                dmg.Activate();
            }
        }

        @Override
        public boolean isWeapon(GearItemData gear) {
            try {
                if (gear == null) {
                    return false;
                }
                if (gear.GetBaseGearType() instanceof IWeapon) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        public void setTier(int tier) {
            this.tier = tier;
        }

        @Override
        public int getTier() {
            return this.tier;
        }

        @Override
        public float getStatMultiplierIncreaseByTier() {
            return 1.0f + (float)this.tier * 0.15f;
        }

        @Override
        public float getDMGMultiplierIncreaseByTier() {
            return 1.0f + (float)this.tier * 0.2f;
        }

        @Override
        public CustomStatsData getCustomStats() {
            return this.customStats;
        }

        @Override
        public CustomExactStatsData getCustomExactStats() {
            return this.customExactStats;
        }

        @Override
        public ResourcesData getResources() {
            return this.resources;
        }

        @Override
        public float getCurrentEnergy() {
            return this.resources.getEnergy();
        }

        @Override
        public float getCurrentMana() {
            return this.resources.getMana();
        }

        @Override
        public int getLvlForResourceCosts() {
            return this.getLevel();
        }

        @Override
        public void setAverageGearLevel(int lvl) {
            this.averageGearLevel = lvl;
        }

        @Override
        public void freelySetLevel(int lvl) {
            this.level = lvl;
        }

        @Override
        public boolean isNewbie() {
            return this.isNewbie;
        }

        @Override
        public void setNewbieStatus(boolean bool) {
            this.isNewbie = bool;
        }

        @Override
        public boolean needsToBeGivenStats() {
            return !this.setMobStats;
        }
    }

    public static class Provider
    extends BaseProvider<UnitData> {
        @Override
        public UnitData defaultImpl() {
            return new DefaultImpl();
        }

        @Override
        public Capability<UnitData> dataInstance() {
            return Data;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof ArmorStandEntity) {
                return;
            }
            if (event.getObject() instanceof LivingEntity) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new Provider());
            }
        }
    }

    public static interface UnitData
    extends ICommonCapability {
        public void modifyResource(ResourcesData.Context var1);

        public void onDeath(LivingEntity var1);

        public void setType(LivingEntity var1);

        public EntityTypeUtils.EntityType getType();

        public void trySync(LivingEntity var1);

        public void onAttackEntity(LivingEntity var1, LivingEntity var2);

        public void syncToClient(PlayerEntity var1);

        public GearItemData getWeaponData(LivingEntity var1);

        public void setEquipsChanged(boolean var1);

        public void onDamagedByNonPlayer(LivingEntity var1, float var2);

        public boolean shouldDropLoot();

        public int PostGiveExpEvent(LivingEntity var1, PlayerEntity var2, int var3);

        public boolean isNewbie();

        public void setNewbieStatus(boolean var1);

        public boolean needsToBeGivenStats();

        public void freelySetLevel(int var1);

        public int getLevel();

        public void mobBasicAttack(LivingHurtEvent var1, LivingEntity var2, LivingEntity var3, UnitData var4, UnitData var5, float var6);

        public void setLevel(int var1, LivingEntity var2);

        public boolean increaseRarity(LivingEntity var1);

        public int getExp();

        public void setExp(int var1);

        public int GiveExp(PlayerEntity var1, int var2);

        public int GetExpRequiredForLevelUp();

        public boolean CheckIfCanLevelUp();

        public boolean LevelUp(PlayerEntity var1);

        public boolean CheckLevelCap();

        public void SetMobLevelAtSpawn(LivingEntity var1, PlayerEntity var2);

        public Unit getUnit();

        public void setUnit(Unit var1, LivingEntity var2);

        public void setRarity(int var1);

        public int getRarity();

        public String getUUID();

        public void setUUID(UUID var1);

        public ITextComponent getName(LivingEntity var1);

        public void HandleCloneEvent(UnitData var1);

        public void recalculateStats(LivingEntity var1);

        public void forceRecalculateStats(LivingEntity var1);

        public void forceSetUnit(Unit var1);

        public boolean tryUseWeapon(GearItemData var1, LivingEntity var2);

        public boolean tryUseWeapon(GearItemData var1, LivingEntity var2, float var3);

        public void attackWithWeapon(LivingHurtEvent var1, ItemStack var2, GearItemData var3, LivingEntity var4, LivingEntity var5, UnitData var6);

        public void onLogin(PlayerEntity var1);

        public String getCurrentMapId();

        public void setCurrentMapId(String var1);

        public boolean hasCurrentMapId();

        public void clearCurrentMapId();

        public void unarmedAttack(LivingHurtEvent var1, LivingEntity var2, LivingEntity var3, UnitData var4);

        public boolean decreaseRarity(LivingEntity var1);

        public boolean isWeapon(GearItemData var1);

        public void setTier(int var1);

        public int getTier();

        public float getStatMultiplierIncreaseByTier();

        public float getDMGMultiplierIncreaseByTier();

        public CustomStatsData getCustomStats();

        public CustomExactStatsData getCustomExactStats();

        public ResourcesData getResources();

        public float getCurrentEnergy();

        public float getCurrentMana();

        public int getLvlForResourceCosts();

        public void setAverageGearLevel(int var1);
    }
}

