/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.saveclasses.item_classes.MapItemData;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseProvider;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseStorage;
import com.robertx22.mine_and_slash.uncommon.capability.bases.ICommonCapability;
import com.robertx22.mine_and_slash.uncommon.datasaving.Map;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerMapCap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "playermapdata");
    @CapabilityInject(value=IPlayerMapData.class)
    public static final Capability<IPlayerMapData> Data = null;
    static final String POS_OBJ = "POS_OBJ";
    static final String ORIGINAL_DIM = "original_dimension";
    static final String MIN_PASSED = "MIN_PASSED";

    public static class Storage
    extends BaseStorage<IPlayerMapData> {
    }

    public static class DefaultImpl
    implements IPlayerMapData {
        long mapDevicePos;
        MapItemData mapdata = new MapItemData();
        DimensionType originalDimension = null;
        int minutesPassed = 0;
        boolean isDead = false;

        @Override
        public CompoundNBT getNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74772_a(PlayerMapCap.POS_OBJ, this.mapDevicePos);
            nbt.func_74768_a(PlayerMapCap.MIN_PASSED, this.minutesPassed);
            nbt.func_74757_a("isdead", this.isDead);
            if (this.mapdata != null) {
                Map.Save(nbt, this.mapdata);
            }
            if (this.originalDimension != null) {
                nbt.func_74778_a(PlayerMapCap.ORIGINAL_DIM, MapManager.getResourceLocation(this.originalDimension).toString());
            }
            return nbt;
        }

        @Override
        public void setNBT(CompoundNBT nbt) {
            this.mapDevicePos = nbt.func_74763_f(PlayerMapCap.POS_OBJ);
            this.minutesPassed = nbt.func_74762_e(PlayerMapCap.MIN_PASSED);
            this.isDead = nbt.func_74767_n("isdead");
            this.mapdata = Map.Load(nbt);
            this.originalDimension = nbt.func_74764_b(PlayerMapCap.ORIGINAL_DIM) ? DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(nbt.func_74779_i(PlayerMapCap.ORIGINAL_DIM))) : DimensionType.field_223227_a_;
        }

        @Override
        public void onPlayerDeath(PlayerEntity player) {
            this.isDead = true;
            if (this.isPermaDeath()) {
                this.minutesPassed += 555555;
                player.func_145747_a(Chats.Player_died_in_a_map_world.locName().func_150258_a(" " + player.func_145748_c_().func_150254_d() + " ").func_150257_a(Chats.Time_ran_out_due_to_Permadeath.locName()));
            } else {
                int punishment = 5;
                player.func_145747_a(Chats.Player_died_in_a_map_world.locName().func_150258_a(" " + player.func_145748_c_().func_150254_d() + " ").func_150257_a(Chats.Map_time_penalty_activated.locName()));
                this.minutesPassed += punishment;
                this.announceTimeLeft(player);
            }
            if (((Boolean)ModConfig.INSTANCE.Server.DISABLE_DEATH_IN_MAPS.get()).booleanValue()) {
                player.func_70606_j(player.func_110138_aP());
            }
        }

        @Override
        public boolean isPermaDeath() {
            return this.mapdata.isPermaDeath;
        }

        @Override
        public void onMinute(PlayerEntity player) {
            ++this.minutesPassed;
            if (this.getMinutesLeft() < 1) {
                this.announceEnd(player);
                this.teleportPlayerBack(player);
            } else {
                this.onMinutePassAnnounce(player);
            }
        }

        @Override
        public void init(BlockPos pos, MapItemData map, DimensionType type, PlayerEntity player) {
            this.minutesPassed = 0;
            this.mapDevicePos = pos.func_218275_a();
            this.originalDimension = player.field_70170_p.func_201675_m().func_186058_p();
            this.mapdata = map.clone();
            MMORPG.syncMapData((ServerPlayerEntity)player);
        }

        private void onMinutePassAnnounce(PlayerEntity player) {
            int minutesLeft = this.getMinutesLeft();
            if (minutesLeft > 0 && (minutesLeft < 5 || minutesLeft % 5 == 0)) {
                this.announceTimeLeft(player);
            }
        }

        @Override
        public void onTickIfDead(ServerPlayerEntity player) {
            if (this.isDead) {
                this.isDead = false;
                this.teleportPlayerBack((PlayerEntity)player);
            }
        }

        @Override
        public float getLootMultiplier(PlayerEntity player) {
            if (WorldUtils.isMapWorld((IWorld)player.field_70170_p)) {
                return this.mapdata.getBonusLootMulti();
            }
            return 1.0f;
        }

        @Override
        public float getExpMultiplier() {
            return 1.0f + (float)this.getMap().tier * 0.05f;
        }

        @Override
        public String getLastMapGUID() {
            return this.getMap().mapUUID;
        }

        @Override
        public boolean hasTimeForMap() {
            return this.getMinutesLeft() > 0;
        }

        @Override
        public int getLevel() {
            return this.mapdata.level;
        }

        @Override
        public int getTier() {
            return this.mapdata.tier;
        }

        @Override
        public MapItemData getMap() {
            if (this.mapdata != null) {
                return this.mapdata;
            }
            return MapItemData.empty();
        }

        @Override
        public BlockPos getMapDevicePos() {
            return BlockPos.func_218283_e((long)this.mapDevicePos).func_177970_e(3);
        }

        @Override
        public DimensionType getOriginalDimension() {
            return this.originalDimension;
        }

        private static void error(String str) {
            System.out.println("[Mine and Slash Map Error]: " + str);
        }

        @Override
        public void teleportPlayerBack(PlayerEntity player) {
            if (WorldUtils.isMapWorld((IWorld)player.field_70170_p)) {
                BlockPos pos;
                if (this.originalDimension == null) {
                    DefaultImpl.error("Original Dimension is null");
                    this.originalDimension = DimensionType.field_223227_a_;
                }
                if ((pos = this.getMapDevicePos()) == null) {
                    DefaultImpl.error("Map device pos is null");
                    pos = player.func_180470_cg();
                    if (pos == null) {
                        DefaultImpl.error("Bed location attempt:1 is null");
                    }
                    try {
                        Optional opt = player.func_213374_dv();
                        if (opt.isPresent()) {
                            pos = (BlockPos)opt.get();
                        }
                    }
                    catch (Exception e) {
                        DefaultImpl.error("Bed location attempt:2 is null");
                    }
                }
                if (pos == null) {
                    try {
                        pos = MapManager.getWorld(DimensionType.field_223227_a_).func_175694_M();
                    }
                    catch (Exception e) {
                        DefaultImpl.error("Last safeguard failed, can't even get spawn point of overworld");
                        e.printStackTrace();
                        pos = new BlockPos(0, 90, 0);
                    }
                }
                pos = pos.func_177964_d(2);
                PlayerUtils.changeDimension((ServerPlayerEntity)player, this.originalDimension, pos);
            }
        }

        private void announceEnd(PlayerEntity player) {
            player.func_145747_a(Chats.Ran_Out_Of_Time.locName());
        }

        private void announceTimeLeft(PlayerEntity player) {
            player.func_145747_a(Chats.Remaining_Map_Time_is.locName().func_150258_a(" " + this.getMinutesLeft() + " ").func_150257_a(Words.Minutes.locName()));
        }

        private int getMinutesLeft() {
            return this.getMap().minutes - this.minutesPassed;
        }
    }

    public static class Provider
    extends BaseProvider<IPlayerMapData> {
        @Override
        public IPlayerMapData defaultImpl() {
            return new DefaultImpl();
        }

        @Override
        public Capability<IPlayerMapData> dataInstance() {
            return Data;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new Provider());
            }
        }
    }

    public static interface IPlayerMapData
    extends ICommonCapability {
        public void onTickIfDead(ServerPlayerEntity var1);

        public float getLootMultiplier(PlayerEntity var1);

        public float getExpMultiplier();

        public String getLastMapGUID();

        public boolean hasTimeForMap();

        public int getLevel();

        public int getTier();

        public MapItemData getMap();

        public BlockPos getMapDevicePos();

        public DimensionType getOriginalDimension();

        public void teleportPlayerBack(PlayerEntity var1);

        public void onPlayerDeath(PlayerEntity var1);

        public boolean isPermaDeath();

        public void onMinute(PlayerEntity var1);

        public void init(BlockPos var1, MapItemData var2, DimensionType var3, PlayerEntity var4);
    }
}

