/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.talent_tree.Perk;
import com.robertx22.mine_and_slash.database.talent_tree.PerkConnection;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.talents.PlayerTalentsData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseProvider;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseStorage;
import com.robertx22.mine_and_slash.uncommon.capability.bases.ICommonCapability;
import com.robertx22.mine_and_slash.uncommon.datasaving.base.LoadSave;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerTalentsCap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "player_talents");
    private static final String LOC = "PLAYER_TALENTS_DATA";
    @CapabilityInject(value=IPlayerTalentsData.class)
    public static final Capability<IPlayerTalentsData> Data = null;

    public static class Storage
    extends BaseStorage<IPlayerTalentsData> {
    }

    public static class DefaultImpl
    implements IPlayerTalentsData {
        PlayerTalentsData data = new PlayerTalentsData();

        @Override
        public CompoundNBT getNBT() {
            CompoundNBT nbt = new CompoundNBT();
            LoadSave.Save(this.data, nbt, PlayerTalentsCap.LOC);
            return nbt;
        }

        @Override
        public void setNBT(CompoundNBT nbt) {
            this.data = LoadSave.Load(PlayerTalentsData.class, new PlayerTalentsData(), nbt, PlayerTalentsCap.LOC);
            if (this.data == null) {
                this.data = new PlayerTalentsData();
            }
        }

        @Override
        public Set<PerkConnection> getConnections() {
            HashSet<PerkConnection> set = new HashSet<PerkConnection>();
            for (Perk talent : SlashRegistry.Perks().getList()) {
                if (this.data.isAllocated(talent)) {
                    for (Perk con : talent.connections) {
                        if (this.data.isAllocated(con)) {
                            set.add(new PerkConnection(PerkConnection.Allocation.ALLOCATED, talent, con));
                            continue;
                        }
                        set.add(new PerkConnection(PerkConnection.Allocation.CAN_ALLOCATE, talent, con));
                    }
                    continue;
                }
                for (Perk con : talent.connections) {
                    if (this.data.isAllocated(con)) {
                        set.add(new PerkConnection(PerkConnection.Allocation.CAN_ALLOCATE, talent, con));
                        continue;
                    }
                    set.add(new PerkConnection(PerkConnection.Allocation.CANT_ALLOCATE, talent, con));
                }
            }
            return set;
        }

        @Override
        public boolean canAllocatePoint(Perk talent, EntityCap.UnitData data) {
            if (!(this.getFreePoints(data) > 0)) {
                return false;
            }
            if (talent.isStart) {
                return !this.getData().getAllCurrentTalents().stream().anyMatch(x -> x.isStart);
            }
            boolean can = false;
            for (Perk con : talent.connections) {
                if (!this.data.isAllocated(con)) continue;
                can = true;
                break;
            }
            return can;
        }

        @Override
        public boolean hasPerk(Perk perk) {
            return this.getData().isAllocated(perk);
        }

        @Override
        public boolean tryRemovePoint(Perk talent) {
            if (this.getData().canRemove(talent)) {
                this.getData().remove(talent.GUID());
                --this.getData().resetPoints;
                return true;
            }
            return false;
        }

        @Override
        public void allocate(Perk talent) {
            this.data.allocate(talent.GUID());
        }

        @Override
        public int getFreePoints(EntityCap.UnitData data) {
            return this.getAllowedPoints(data) - this.getAllocatedPoints();
        }

        public int getAllowedPoints(EntityCap.UnitData data) {
            return (int)((double)data.getLevel() * (Double)ModConfig.INSTANCE.Server.TALENT_POINTS_PER_LEVEL.get());
        }

        @Override
        public int getAllocatedPoints() {
            return this.data.getAllocatedTalents();
        }

        @Override
        public void reset() {
            this.data.reset();
        }

        @Override
        public void applyStats(EntityCap.UnitData data, PlayerEntity player) {
            this.data.applyStats(data);
        }

        @Override
        public void addResetPoints(int amount) {
            this.getData().resetPoints += amount;
        }

        @Override
        public PlayerTalentsData getData() {
            return this.data;
        }
    }

    public static class Provider
    extends BaseProvider<IPlayerTalentsData> {
        @Override
        public IPlayerTalentsData defaultImpl() {
            return new DefaultImpl();
        }

        @Override
        public Capability<IPlayerTalentsData> dataInstance() {
            return Data;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new Provider());
            }
        }
    }

    public static interface IPlayerTalentsData
    extends ICommonCapability {
        public Set<PerkConnection> getConnections();

        public boolean canAllocatePoint(Perk var1, EntityCap.UnitData var2);

        public boolean hasPerk(Perk var1);

        public boolean tryRemovePoint(Perk var1);

        public void allocate(Perk var1);

        public int getFreePoints(EntityCap.UnitData var1);

        public int getAllocatedPoints();

        public void reset();

        public void applyStats(EntityCap.UnitData var1, PlayerEntity var2);

        public void addResetPoints(int var1);

        public PlayerTalentsData getData();
    }
}

