/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability;

import com.robertx22.mine_and_slash.professions.blocks.bases.Professions;
import com.robertx22.mine_and_slash.professions.recipe.BaseRecipe;
import com.robertx22.mine_and_slash.saveclasses.professions.ProfessionData;
import com.robertx22.mine_and_slash.saveclasses.professions.ProfessionListData;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseProvider;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseStorage;
import com.robertx22.mine_and_slash.uncommon.capability.bases.ICommonCapability;
import com.robertx22.mine_and_slash.uncommon.datasaving.ProfessionSaving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ProfessionsCap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "professions");
    @CapabilityInject(value=IProfessionsData.class)
    public static final Capability<IProfessionsData> Data = null;

    public static class Storage
    extends BaseStorage<IProfessionsData> {
    }

    public static class DefaultImpl
    implements IProfessionsData {
        ProfessionListData data = new ProfessionListData();

        @Override
        public CompoundNBT getNBT() {
            CompoundNBT nbt = new CompoundNBT();
            ProfessionSaving.Save(nbt, this.data);
            return nbt;
        }

        @Override
        public void setNBT(CompoundNBT nbt) {
            this.data = ProfessionSaving.Load(nbt);
        }

        @Override
        public int getLevel(Professions prof) {
            return this.data.getProfessionData((Professions)prof).level;
        }

        @Override
        public int setLevel(Professions prof, int lvl) {
            this.data.getProfessionData((Professions)prof).level = lvl;
            return this.data.getProfessionData((Professions)prof).level;
        }

        @Override
        public int getCurrentExp(Professions prof) {
            return this.data.getProfessionData((Professions)prof).exp;
        }

        @Override
        public int getExpToReachNextLevel(Professions prof) {
            int lvl = this.getLevel(prof);
            return (int)DefaultImpl.calculateStatGrowth(100.0f, lvl);
        }

        public static float calculateStatGrowth(float stat, int lvl) {
            return stat * (float)Math.pow(lvl, DefaultImpl.getMultiplier(lvl));
        }

        private static float getMultiplier(int lvl) {
            return MathHelper.func_76131_a((float)(0.4f + (float)lvl / 50.0f), (float)0.4f, (float)1.4f);
        }

        @Override
        public void gainExp(int exp, Professions prof, ServerPlayerEntity player) {
            ProfessionData pdata = this.data.getProfessionData(prof);
            pdata.exp += exp;
            int expReq = this.getExpToReachNextLevel(prof);
            if (pdata.exp > expReq && Professions.MAX_LEVEL > pdata.level) {
                pdata.exp -= expReq;
                ++pdata.level;
                player.func_184185_a(SoundEvents.field_187802_ec, 1.0f, 1.0f);
            }
        }

        @Override
        public float getSucessChanceMultiplier(Professions prof) {
            return 1.0f + (float)this.getLevel(prof) * 0.01f;
        }

        @Override
        public boolean canCraftRecipe(BaseRecipe recipe) {
            return this.getLevel(recipe.profession()) >= recipe.professionLevelReq;
        }
    }

    public static class Provider
    extends BaseProvider<IProfessionsData> {
        @Override
        public IProfessionsData defaultImpl() {
            return new DefaultImpl();
        }

        @Override
        public Capability<IProfessionsData> dataInstance() {
            return Data;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new Provider());
            }
        }
    }

    public static interface IProfessionsData
    extends ICommonCapability {
        public int getLevel(Professions var1);

        public int setLevel(Professions var1, int var2);

        public int getCurrentExp(Professions var1);

        public int getExpToReachNextLevel(Professions var1);

        public void gainExp(int var1, Professions var2, ServerPlayerEntity var3);

        public float getSucessChanceMultiplier(Professions var1);

        public boolean canCraftRecipe(BaseRecipe var1);
    }
}

