/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability;

import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseProvider;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseStorage;
import com.robertx22.mine_and_slash.uncommon.capability.bases.ICommonCapability;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WeaponSpeedCap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "weapon_speed");
    @CapabilityInject(value=IWeaponSpeedCap.class)
    public static final Capability<IWeaponSpeedCap> Data = null;

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer()) {
            Load.weaponSpeed(event.player).onTick();
        }
    }

    public static class Storage
    extends BaseStorage<IWeaponSpeedCap> {
    }

    public static class DefaultImpl
    implements IWeaponSpeedCap {
        int cooldownTicks = 0;

        @Override
        public CompoundNBT getNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("ticks", this.cooldownTicks);
            return nbt;
        }

        @Override
        public void setNBT(CompoundNBT nbt) {
            this.cooldownTicks = nbt.func_74762_e("ticks");
        }

        @Override
        public void onAttack(PlayerEntity en) {
            ItemStack stack = en.func_184614_ca();
            GearItemData gear = Gear.Load(stack);
            if (gear != null) {
                this.cooldownTicks = gear.GetBaseGearType().cooldownTicks();
            }
        }

        @Override
        public boolean canAttack() {
            return this.cooldownTicks <= 0;
        }

        @Override
        public void onTick() {
            if (this.cooldownTicks > 0) {
                this.cooldownTicks = MathHelper.func_76125_a((int)(this.cooldownTicks - 1), (int)0, (int)1000);
            }
        }
    }

    public static class Provider
    extends BaseProvider<IWeaponSpeedCap> {
        @Override
        public IWeaponSpeedCap defaultImpl() {
            return new DefaultImpl();
        }

        @Override
        public Capability<IWeaponSpeedCap> dataInstance() {
            return Data;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new Provider());
            }
        }
    }

    public static interface IWeaponSpeedCap
    extends ICommonCapability {
        public void onAttack(PlayerEntity var1);

        public boolean canAttack();

        public void onTick();
    }
}

