/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas;

import com.robertx22.mine_and_slash.api.MineAndSlashEvents;
import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.spells.bases.MyDamageSource;
import com.robertx22.mine_and_slash.database.stats.effects.defense.BlockEffect;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.network.DmgNumPacket;
import com.robertx22.mine_and_slash.onevent.entity.damage.DmgSourceUtils;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IArmorReducable;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.ICrittable;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IDamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IElementalPenetrable;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IElementalResistable;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IPenetrable;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.HealthUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;

public class DamageEffect
extends EffectData
implements IArmorReducable,
IPenetrable,
IDamageEffect,
IElementalResistable,
IElementalPenetrable,
ICrittable {
    LivingHurtEvent event;
    private HashMap<Elements, Integer> bonusElementDamageMap = new HashMap();
    public static String dmgSourceName = "mmorpg.custom_damage";
    public Elements element = Elements.Physical;
    public int armorPene;
    public int elementalPene;
    public float damageMultiplier = 1.0f;
    public float healthHealed;
    public float manaRestored;
    public boolean isFullyBlocked = false;
    public boolean isPartiallyBlocked = false;
    public boolean isDodged = false;
    boolean removeKnockback = false;
    public boolean crit = false;

    public DamageEffect(LivingHurtEvent event, LivingEntity source, LivingEntity target, int dmg, EntityCap.UnitData sourceData, EntityCap.UnitData targetData, EffectData.EffectTypes effectType, WeaponTypes weptype) {
        super(source, target, sourceData, targetData);
        this.setEffectType(effectType, weptype);
        this.number = dmg;
        this.event = event;
    }

    public boolean isElemental() {
        return this.element != null && this.element != Elements.Physical;
    }

    public Elements getHighestBonusElementalDamageElement() {
        int highest = 0;
        Elements ele = null;
        for (Map.Entry<Elements, Integer> entry : this.bonusElementDamageMap.entrySet()) {
            if (entry.getValue() <= highest) continue;
            ele = entry.getKey();
            highest = entry.getValue();
        }
        return ele;
    }

    public void addBonusEleDmgDivideByMulti(Elements element, float dmg) {
        this.addBonusEleDmg(element, dmg / this.damageMultiplier);
    }

    public void addBonusEleDmg(Elements element, float dmg) {
        if (this.bonusElementDamageMap.containsKey(element)) {
            this.bonusElementDamageMap.put(element, (int)((float)this.bonusElementDamageMap.get(element).intValue() + dmg));
        } else {
            this.bonusElementDamageMap.put(element, (int)dmg);
        }
    }

    public boolean isBlocked() {
        return this.isFullyBlocked || this.isPartiallyBlocked;
    }

    public boolean isDmgAllowed() {
        return !this.isFullyBlocked && !this.isDodged;
    }

    public float getActualDamage() {
        float dmg = this.number * this.damageMultiplier;
        if (dmg <= 0.0f) {
            return 0.0f;
        }
        dmg = HealthUtils.DamageToMinecraftHealth(dmg, this.target, this.targetData);
        return dmg;
    }

    public float getVisibleDamage() {
        float dmg = this.number * this.damageMultiplier;
        return dmg;
    }

    public float getEventDmg() {
        if (this.event != null) {
            return this.event.getAmount();
        }
        return 0.0f;
    }

    public void removeKnockback() {
        this.removeKnockback = true;
    }

    @Override
    protected void activate() {
        if (this.target.func_110143_aJ() <= 0.0f || !this.target.func_70089_S()) {
            return;
        }
        if (this.canceled) {
            return;
        }
        MyDamageSource dmgsource = new MyDamageSource(dmgSourceName, (Entity)this.source, this.element, (int)this.number);
        if (this.removeKnockback) {
            BlockEffect.applyKnockbackResist(this.target);
        }
        if (this.isPartiallyBlocked) {
            dmgsource.func_76348_h();
        }
        if (this.isDmgAllowed()) {
            MinecraftForge.EVENT_BUS.post((Event)new MineAndSlashEvents.OnDmgDoneEvent(this.source, this));
            this.sourceData.onAttackEntity(this.source, this.target);
            DmgByElement info = this.getDmgByElement();
            float dmg = info.totalDmg;
            dmg += this.getEventDmg() * ((Double)ModConfig.INSTANCE.Server.NON_MOD_DAMAGE_MULTI.get()).floatValue();
            if (this.event != null) {
                this.event.setAmount(dmg);
                this.event.getSource().func_76348_h();
                this.event.getSource().func_151518_m();
                DmgSourceUtils.markSourceAsMine(this.event.getSource());
            } else {
                int hurtResistantTime = this.target.field_70172_ad;
                this.target.field_70172_ad = 0;
                this.target.func_70097_a((DamageSource)dmgsource, dmg);
                this.target.field_70172_ad = hurtResistantTime;
            }
            this.Heal();
            this.RestoreMana();
            if (dmg > 0.0f && this.source instanceof ServerPlayerEntity && info.highestDmgElement != null) {
                ServerPlayerEntity player = (ServerPlayerEntity)this.source;
                DmgNumPacket packet = new DmgNumPacket(this.target, info.highestDmgElement, NumberUtils.formatDamageNumber(this, (int)HealthUtils.vanillaHealthToActualHealth(dmg, this.target, this.targetData)));
                MMORPG.sendToClient(packet, player);
            }
        }
        BlockEffect.removeKnockbackResist(this.target);
    }

    public void RestoreMana() {
        int restored = (int)this.manaRestored;
        if (restored > 0) {
            this.sourceData.getResources().modify(new ResourcesData.Context(this.sourceData, this.source, ResourcesData.Type.MANA, restored, ResourcesData.Use.RESTORE));
        }
    }

    public void Heal() {
        int healed = (int)this.healthHealed;
        if (healed > 0) {
            this.sourceData.getResources().modify(new ResourcesData.Context(this.sourceData, this.source, ResourcesData.Type.HEALTH, healed, ResourcesData.Use.RESTORE));
        }
    }

    public DamageEffect setMultiplier(float multi) {
        this.damageMultiplier = multi;
        return this;
    }

    public DmgByElement getDmgByElement() {
        DmgByElement info = new DmgByElement();
        for (Map.Entry<Elements, Integer> entry : this.bonusElementDamageMap.entrySet()) {
            if (entry.getValue() <= 0) continue;
            DamageEffect bonus = new DamageEffect(null, this.source, this.target, entry.getValue(), this.sourceData, this.targetData, EffectData.EffectTypes.BONUS_ATTACK, this.weaponType);
            bonus.element = entry.getKey();
            bonus.damageMultiplier = this.damageMultiplier;
            bonus.calculateEffects();
            info.addDmg(bonus.getActualDamage(), bonus.element);
        }
        info.addDmg(this.getActualDamage(), this.element);
        return info;
    }

    @Override
    public LivingEntity Source() {
        return this.source;
    }

    @Override
    public LivingEntity Target() {
        return this.target;
    }

    @Override
    public float Number() {
        return this.number;
    }

    @Override
    public Elements GetElement() {
        return this.element;
    }

    @Override
    public void SetArmorPenetration(int val) {
        this.armorPene = val;
    }

    @Override
    public void addElementalPenetration(int val) {
        this.elementalPene += val;
    }

    @Override
    public int GetArmorPenetration() {
        return this.armorPene;
    }

    @Override
    public void setCrit(boolean bool) {
        this.crit = bool;
    }

    @Override
    public boolean isCriticalHit() {
        return this.crit;
    }

    @Override
    public int GetElementalPenetration() {
        return this.elementalPene;
    }

    public static class DmgByElement {
        public HashMap<Elements, Float> dmgmap = new HashMap();
        public Elements highestDmgElement;
        public float highestDmgValue;
        public float totalDmg = 0.0f;

        public void addDmg(float dmg, Elements element) {
            Elements ele = element;
            if (ele == null) {
                ele = Elements.Physical;
            }
            float total = this.dmgmap.getOrDefault(element, Float.valueOf(0.0f)).floatValue() + dmg;
            this.dmgmap.put(ele, Float.valueOf(total));
            this.totalDmg += dmg;
            if (total > this.highestDmgValue) {
                this.highestDmgElement = ele;
                this.highestDmgValue = total;
            }
        }
    }
}

