/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.db_lists.initializers.Stats;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectUnitStat;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class EffectData {
    public EntityCap.UnitData sourceData;
    public EntityCap.UnitData targetData;
    public boolean canceled = false;
    public Unit sourceUnit;
    public Unit targetUnit;
    public LivingEntity source;
    public LivingEntity target;
    public float number = 0.0f;
    private EffectTypes effectType = EffectTypes.BASIC_ATTACK;
    public WeaponTypes weaponType = WeaponTypes.None;
    boolean effectsCalculated = false;

    public EffectData(LivingEntity source, LivingEntity target) {
        this.source = source;
        this.target = target;
        if (target != null) {
            this.targetData = Load.Unit((ICapabilityProvider)target);
        }
        if (source != null) {
            this.sourceData = Load.Unit((ICapabilityProvider)source);
        }
        if (source != null) {
            try {
                if (target != null) {
                    this.targetUnit = this.targetData.getUnit();
                }
                this.sourceUnit = this.sourceData.getUnit();
                if (this.sourceUnit != null) {
                    this.sourceData.recalculateStats(source);
                } else {
                    this.canceled = true;
                }
                if (this.targetUnit != null) {
                    this.targetData.recalculateStats(target);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public EffectData(LivingEntity source, LivingEntity target, EntityCap.UnitData sourceData, EntityCap.UnitData targetData) {
        this.source = source;
        this.target = target;
        if (sourceData != null && targetData != null) {
            this.sourceData = sourceData;
            this.targetData = targetData;
            this.sourceUnit = sourceData.getUnit();
            this.targetUnit = targetData.getUnit();
        } else {
            this.canceled = true;
        }
    }

    public EffectTypes getEffectType() {
        return this.effectType;
    }

    public void setEffectType(EffectTypes effectType, WeaponTypes weaponType) {
        this.effectType = effectType;
        this.weaponType = weaponType;
    }

    public Unit GetSource() {
        return this.sourceUnit;
    }

    public Unit GetTarget() {
        return this.targetUnit;
    }

    public void Activate() {
        this.calculateEffects();
        if (!this.canceled) {
            this.activate();
        }
    }

    public void calculateEffects() {
        if (!this.effectsCalculated) {
            this.effectsCalculated = true;
            if (this.source == null || this.target == null || this.canceled || this.sourceUnit == null || this.targetUnit == null || this.sourceData == null || this.targetData == null) {
                return;
            }
            this.TryApplyEffects(this.GetSource(), IStatEffect.EffectSides.Source);
            this.TryApplyEffects(this.GetTarget(), IStatEffect.EffectSides.Target);
        }
    }

    protected abstract void activate();

    protected EffectData TryApplyEffects(Unit unit, IStatEffect.EffectSides side) {
        if (this.canceled) {
            return this;
        }
        List<EffectUnitStat> Effects2 = new ArrayList<EffectUnitStat>();
        Effects2 = this.AddEffects(Effects2, unit, side);
        Effects2.sort(new EffectUnitStat());
        for (EffectUnitStat item : Effects2) {
            if (item.stat.Value == 0.0f || !this.AffectsThisUnit(item.effect, this, item.source)) continue;
            item.effect.TryModifyEffect(this, item.source, item.stat, item.stat.GetStat());
        }
        return this;
    }

    public boolean AffectsThisUnit(IStatEffect effect, EffectData data, Unit source) {
        boolean affects = false;
        affects = effect.Side().equals((Object)IStatEffect.EffectSides.Target) ? source.equals(data.targetUnit) : source.equals(data.sourceUnit);
        if (!affects) {
            System.out.println("works");
        }
        return affects;
    }

    private List<EffectUnitStat> AddEffects(List<EffectUnitStat> effects, Unit unit, IStatEffect.EffectSides side) {
        if (unit != null) {
            for (IStatEffects stateffects : Stats.allPreGenMapStatLists.get(IStatEffects.class)) {
                if (!stateffects.getEffect().Side().equals((Object)side)) continue;
                StatData stat = unit.getStat((Stat)((Object)stateffects));
                if (stat.Value == 0.0f) continue;
                effects.add(new EffectUnitStat(stateffects.getEffect(), unit, stat));
            }
        }
        return effects;
    }

    public static enum EffectTypes {
        NORMAL,
        SPELL,
        BASIC_ATTACK,
        BONUS_ATTACK,
        REFLECT,
        DOT_DMG;

    }
}

