/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas;

import com.robertx22.mine_and_slash.database.spells.bases.BaseSpell;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectUnitStat;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IBuffableSpell;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SpellBuffEffect
extends EffectData
implements IBuffableSpell {
    public IBuffableSpell buffable;
    private IBuffableSpell.SpellBuffType buff = IBuffableSpell.SpellBuffType.None;

    public SpellBuffEffect(LivingEntity source, IBuffableSpell buffable) {
        super(source, null);
        this.canceled = false;
        this.buffable = buffable;
        this.source = source;
        this.sourceData = Load.Unit((ICapabilityProvider)source);
        try {
            this.sourceUnit = this.sourceData.getUnit();
            if (this.sourceUnit != null) {
                this.sourceData.recalculateStats(source);
            } else {
                this.canceled = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void activate() {
        this.buffable.setBuff(this.buff);
    }

    @Override
    public void Activate() {
        if (this.source == null || this.canceled || this.sourceUnit == null || this.sourceData == null) {
            return;
        }
        this.TryApplyEffects(this.GetSource());
        if (!this.canceled) {
            this.sourceData.setUnit(this.sourceUnit, this.source);
            this.activate();
        }
    }

    protected EffectData TryApplyEffects(Unit unit) {
        if (this.canceled) {
            return this;
        }
        SpellBuffEffect Data = this;
        List<EffectUnitStat> Effects2 = new ArrayList<EffectUnitStat>();
        Effects2 = this.AddEffects(Effects2, unit);
        Effects2.sort(new EffectUnitStat());
        for (EffectUnitStat item : Effects2) {
            if (item.stat.Value == 0.0f || !this.AffectsThisUnit(item.effect, Data, item.source)) continue;
            item.effect.TryModifyEffect(Data, item.source, item.stat, item.stat.GetStat());
        }
        return Data;
    }

    @Override
    public boolean AffectsThisUnit(IStatEffect effect, EffectData data, Unit source) {
        if (effect.Side().equals((Object)IStatEffect.EffectSides.Target)) {
            return source.equals(data.targetUnit);
        }
        return source.equals(data.sourceUnit);
    }

    private List<EffectUnitStat> AddEffects(List<EffectUnitStat> effects, Unit unit) {
        if (unit != null) {
            for (StatData stat : unit.getStats().values()) {
                if (!(stat.GetStat() instanceof IStatEffects)) continue;
                effects.add(new EffectUnitStat(((IStatEffects)((Object)stat.GetStat())).getEffect(), unit, stat));
            }
        }
        return effects;
    }

    @Override
    public void setBuff(IBuffableSpell.SpellBuffType buff) {
        this.buff = buff;
    }

    @Override
    public IBuffableSpell.SpellBuffType getBuff() {
        return this.buff;
    }

    @Override
    public void setBuffType(BaseSpell.SpellType type) {
        this.buffable.setBuffType(type);
    }

    @Override
    public BaseSpell.SpellType getBuffType() {
        return this.buffable.getBuffType();
    }
}

