/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.enumclasses;

import com.robertx22.mine_and_slash.uncommon.interfaces.IColor;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.text.TextFormatting;

public enum Elements implements IColor
{
    Physical(0, new RGB(240, 157, 55), false, "Physical", TextFormatting.GOLD, Items.field_151044_h, "Annihilation", "physical", "\u2726"),
    Fire(1, new RGB(255, 0, 0), true, "Flame", TextFormatting.RED, Items.field_151064_bs, "Firestorms", "fire", "\u2600"),
    Water(2, new RGB(0, 128, 255), true, "Frost", TextFormatting.BLUE, Items.field_151126_ay, "Blizzards", "water", "\u2749"),
    Thunder(3, new RGB(204, 0, 255), true, "Lightning", TextFormatting.LIGHT_PURPLE, Items.field_151114_aO, "Thunderstorms", "thunder", "\u272a"),
    Nature(4, new RGB(0, 204, 0), true, "Venom", TextFormatting.DARK_GREEN, Items.field_151123_aH, "Earthquakes", "nature", "\u273f"),
    Elemental(5, new RGB(0, 0, 0), false, "Elemental", TextFormatting.GOLD, Items.field_151166_bC, "Element Eruption", "elemental", "\u269c");

    public boolean isSingleElement = true;
    public Item projectileItem;
    private RGB color;
    public String disasterName;
    public String dmgName;
    public String guidName;
    public int i = 0;
    public String icon;
    public TextFormatting format;

    private Elements(int i, RGB color, boolean isSingleElement, String dmgname, TextFormatting format, Item item, String disasterName, String guidname, String icon) {
        this.disasterName = disasterName;
        this.i = i;
        this.color = color;
        this.isSingleElement = isSingleElement;
        this.dmgName = dmgname;
        this.format = format;
        this.projectileItem = item;
        this.guidName = guidname;
        this.icon = icon;
    }

    public static List<Elements> getAllSingleElements() {
        return Arrays.stream(Elements.values()).filter(x -> x.isSingleElement).collect(Collectors.toList());
    }

    public static List<Elements> getAllExceptNone() {
        return Arrays.stream(Elements.values()).filter(x -> x != Elemental).collect(Collectors.toList());
    }

    @Override
    public RGB getRGBColor() {
        return this.color;
    }

    public static class RGB {
        private int R;
        private int G;
        private int B;

        public RGB(int R, int G, int B) {
            this.R = R;
            this.G = G;
            this.B = B;
        }

        public float getR() {
            return (float)this.R / 255.0f;
        }

        public float getG() {
            return (float)this.G / 255.0f;
        }

        public float getB() {
            return (float)this.B / 255.0f;
        }

        public int getIntR() {
            return this.R;
        }

        public int getIntG() {
            return this.G;
        }

        public int getIntB() {
            return this.B;
        }
    }
}

