/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.gui.gear_overlay;

import com.robertx22.mine_and_slash.onevent.my_events.CollectGearEvent;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.gui.gear_overlay.GearGuiElement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GearOverlayGUI
extends AbstractGui {
    private Minecraft mc;
    Unit unit;
    EntityCap.UnitData data;
    int ticks = 0;
    List<GearGuiElement> elements = new ArrayList<GearGuiElement>();
    List<GearGuiElement> elementsToRender = new ArrayList<GearGuiElement>();

    public GearOverlayGUI(Minecraft mc) {
        this.mc = mc;
    }

    private void setupElements() {
        this.elements.clear();
        this.elements.add(new GearGuiElement(this.mc.field_71439_g.func_184614_ca(), this.data));
        this.elements.add(new GearGuiElement(this.mc.field_71439_g.func_184592_cb(), this.data));
        CollectGearEvent.getEquipsExcludingWeapon((LivingEntity)this.mc.field_71439_g).forEach(x -> this.elements.add(new GearGuiElement((ItemStack)x, this.data)));
        this.elementsToRender = this.elements.stream().filter(x -> x.shouldRender()).collect(Collectors.toList());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderGearOverlay(RenderGameOverlayEvent event) {
        try {
            if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
                return;
            }
            ++this.ticks;
            if (this.ticks > 25) {
                EntityCap.UnitData newData = Load.Unit((ICapabilityProvider)this.mc.field_71439_g);
                this.ticks = 0;
                Unit newUnit = null;
                if (newData != null) {
                    this.data = newData;
                    if (newData.getUnit() != null) {
                        newUnit = newData.getUnit();
                    }
                    if (newUnit != null) {
                        this.unit = newUnit;
                    }
                    this.setupElements();
                }
            }
            if (this.unit == null || this.data == null || this.mc == null || this.mc.field_71439_g == null) {
                return;
            }
            if (this.mc.field_71439_g.field_70173_aa < 100) {
                return;
            }
            int x = this.mc.field_195558_d.func_198107_o() - 20;
            int y = this.mc.field_195558_d.func_198087_p() / 2 - this.elementsToRender.size() / 2 * 16;
            for (GearGuiElement ele : this.elementsToRender) {
                ele.render(x, y);
                y += 16;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

