/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.gui.stat_point_screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.BaseCoreStat;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.network.SpendStatPointPacket;
import com.robertx22.mine_and_slash.network.sync_cap.CapTypes;
import com.robertx22.mine_and_slash.network.sync_cap.RequestSyncCapToClient;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.LvlPointStat;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.SingleStatPointData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.PlayerStatsPointsCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.gui.BaseScreen;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class StatPointScreen
extends BaseScreen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mmorpg", "textures/gui/stat_point_screen.png");
    int sizeY = 220;
    int sizeX = 215;
    PlayerStatsPointsCap.IPlayerStatPointsData data;
    EntityCap.UnitData unitdata;
    int guiLeft = 0;
    int guiTop = 0;
    private static final ResourceLocation BUTTON_TEX = new ResourceLocation("mmorpg", "textures/gui/button.png");
    static int button_sizeX = 13;
    static int button_sizeY = 13;

    protected void init() {
        super.init();
        this.data = Load.statPoints((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        this.unitdata = Load.Unit((ICapabilityProvider)Minecraft.func_71410_x().field_71439_g);
        this.guiLeft = (this.width - this.sizeX) / 2;
        this.guiTop = (this.height - this.sizeY) / 2;
        MMORPG.sendToServer(new RequestSyncCapToClient(CapTypes.STAT_POINTS));
        int y = 0;
        for (SingleStatPointData single : this.data.getData().getAllStatDatas()) {
            this.buttons.add(new IncreaseStatButton(this.unitdata, this.data, single, this.guiLeft + this.sizeX / 2 + 50, this.guiTop + 40 + y));
            y += button_sizeY + 3;
        }
    }

    public void render(int x, int y, float ticks) {
        this.drawGuiBackgroundLayer(ticks, x, y);
        super.render(x, y, ticks);
        String str = "Stat Points Remaining: " + this.data.getAvailablePoints(Load.Unit((ICapabilityProvider)this.minecraft.field_71439_g));
        Minecraft.func_71410_x().field_71466_p.func_175063_a(str, (float)(this.guiLeft + this.sizeX / 2 + 50 - Minecraft.func_71410_x().field_71466_p.func_78256_a(str)), (float)(this.guiTop + 15), TextFormatting.GREEN.func_211163_e().intValue());
        this.buttons.forEach(b -> b.renderToolTip(x, y));
    }

    protected void drawGuiBackgroundLayer(float partialTicks, int x, int y) {
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(this.minecraft.field_195558_d.func_198107_o() / 2 - this.sizeX / 2, this.minecraft.field_195558_d.func_198087_p() / 2 - this.sizeY / 2, 0, 0, this.sizeX, this.sizeY);
    }

    class IncreaseStatButton
    extends ImageButton {
        FontRenderer font;
        PlayerStatsPointsCap.IPlayerStatPointsData data;
        LvlPointStat stat;
        EntityCap.UnitData unitdata;

        public IncreaseStatButton(EntityCap.UnitData unitdata, PlayerStatsPointsCap.IPlayerStatPointsData data, SingleStatPointData statData, int xPos, int yPos) {
            super(xPos, yPos, button_sizeX, button_sizeY, 0, 0, button_sizeY, BUTTON_TEX, button -> {});
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.data = data;
            this.stat = statData.stat;
            this.unitdata = unitdata;
        }

        public void onClick(double x, double y) {
            super.onClick(x, y);
            if (this.isInside((int)x, (int)y)) {
                MMORPG.sendToServer(new SpendStatPointPacket(this.stat));
                MMORPG.sendToServer(new RequestSyncCapToClient(CapTypes.STAT_POINTS));
            }
        }

        public void renderToolTip(int x, int y) {
            if (this.isInside(x, y)) {
                Stat stat = SlashRegistry.Stats().get(this.stat.statguid);
                ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                tooltip.add(Styles.BLUECOMP().func_150257_a(stat.locName()));
                if (stat instanceof BaseCoreStat) {
                    BaseCoreStat core = (BaseCoreStat)stat;
                    tooltip.addAll(core.getCoreStatTooltip(this.unitdata, this.unitdata.getUnit().getStat(stat)));
                }
                StatPointScreen.this.renderTooltip(TooltipUtils.compsToStrings(tooltip), x, y, Minecraft.func_71410_x().field_71466_p);
            }
        }

        public boolean isInside(int x, int y) {
            return GuiUtils.isInRect(this.x, this.y, button_sizeX, button_sizeY, x, y);
        }

        public void renderButton(int x, int y, float f) {
            super.renderButton(x, y, f);
            TextFormatting format = TextFormatting.YELLOW;
            SingleStatPointData single = this.data.getStatData(this.stat);
            Stat stat = single.getStat();
            String str = single.stat.formatting + single.stat.shortName + format + ": " + TextFormatting.GREEN + single.points + format;
            str = str + ", Current(" + TextFormatting.GREEN + (int)this.unitdata.getUnit().getStat((Stat)stat).Value + format + ")";
            float f2 = this.x - button_sizeX - 5 - this.font.func_78256_a(str);
            int n = this.y - button_sizeY / 2;
            this.font.getClass();
            this.font.func_175063_a(str, f2, (float)(n + 9), format.func_211163_e().intValue());
        }
    }
}

