/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.gui.stats_gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.robertx22.mine_and_slash.database.stats.IUsableStat;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.types.UnknownStat;
import com.robertx22.mine_and_slash.database.talent_tree.RenderUtils;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@OnlyIn(value=Dist.CLIENT)
public class StatOverviewGUI
extends Screen {
    Stat.StatGroup statgroup = Stat.StatGroup.Main;
    int currentElement = 0;
    HashMap<String, List<Stat>> statmap = new HashMap();
    int sizeY = 220;
    int sizeX = 215;
    private static final ResourceLocation texture = new ResourceLocation("mmorpg", "textures/gui/stats_screen.png");
    static int button_sizeX = 18;
    static int button_sizeY = 18;
    static ResourceLocation BUTTON_TEX = new ResourceLocation("");

    public StatOverviewGUI() {
        super((ITextComponent)new StringTextComponent("Stats Screen"));
    }

    public void init() {
        this.genStatList();
    }

    public void render(int x, int y, float ticks) {
        this.minecraft.func_110434_K().func_110577_a(texture);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(this.minecraft.field_195558_d.func_198107_o() / 2 - this.sizeX / 2, this.minecraft.field_195558_d.func_198087_p() / 2 - this.sizeY / 2, 0, 0, this.sizeX, this.sizeY);
        this.renderStats();
        super.render(x, y, ticks);
        this.buttons.forEach(b -> b.renderToolTip(x, y));
    }

    private int getGUIStartX() {
        return this.minecraft.field_195558_d.func_198107_o() / 2 - this.sizeX / 2;
    }

    private int getGUIStartY() {
        return this.minecraft.field_195558_d.func_198087_p() / 2 - this.sizeY / 2;
    }

    private int getTextStartX() {
        return this.minecraft.field_195558_d.func_198107_o() / 2 - this.sizeX / 2 + 35;
    }

    private int getTextStartY() {
        return this.minecraft.field_195558_d.func_198087_p() / 2 - this.sizeY / 2 + 40;
    }

    public String getStatString(Stat stat, EntityCap.UnitData data) {
        String str = stat.translate() + ": " + data.getUnit().getStat(stat).formattedValue();
        if (stat.IsPercent()) {
            str = str + '%';
        }
        if (stat instanceof IUsableStat) {
            IUsableStat usable = (IUsableStat)((Object)stat);
            String value = NumberUtils.formatNumber(usable.GetUsableValue(data.getLevel(), (int)data.getUnit().getStat((Stat)stat).Value) * 100.0f);
            str = str + " (" + value + "%)";
        }
        return str;
    }

    private List<Stat> getList() {
        ArrayList<Stat> list = new ArrayList<Stat>();
        this.statmap.forEach((key, value) -> {
            list.addAll((Collection<Stat>)value);
            list.add(new UnknownStat());
        });
        return list;
    }

    private int drawTitleAndIncreaseSpacing(int x, int y, String str) {
        this.drawString(this.minecraft.field_71466_p, str, x, y, TextFormatting.GREEN.func_211163_e());
        return this.getHeightSpacing();
    }

    private int renderStats() {
        List<Stat> list = this.getList();
        int x = this.getTextStartX();
        int y = this.getTextStartY();
        int added = 0;
        added += this.drawTitleAndIncreaseSpacing(x - 22, y + added, this.statgroup.word.translate() + ": ");
        y += (added += this.getHeightSpacing() / 3);
        ArrayList<Widget> newlist = new ArrayList<Widget>();
        for (Widget button : new ArrayList(this.buttons)) {
            if (button instanceof StatButton) continue;
            newlist.add(button);
        }
        this.buttons.clear();
        this.buttons.addAll(newlist);
        EntityCap.UnitData data = Load.Unit((ICapabilityProvider)this.minecraft.field_71439_g);
        for (int i = this.currentElement; i < list.size(); ++i) {
            if (i <= -1 || added >= this.sizeY - 60) continue;
            Stat stat = list.get(i);
            if (!(stat instanceof UnknownStat)) {
                this.addButton((Widget)new StatButton(data, stat, x, y));
            }
            y += this.getHeightSpacing();
            added += this.getHeightSpacing();
        }
        return list.size();
    }

    private int getHeightSpacing() {
        return 18;
    }

    public boolean mouseScrolled(double num1, double num2, double num3) {
        this.currentElement = (int)((double)this.currentElement - num3);
        this.currentElement = MathHelper.func_76125_a((int)this.currentElement, (int)0, (int)this.renderStats());
        return false;
    }

    void genStatList() {
        this.statmap = new HashMap();
        List statlist = SlashRegistry.Stats().getAll().values().stream().filter(stat -> stat.IsShownOnStatGui() && stat.statGroup().equals((Object)this.statgroup)).collect(Collectors.toList());
        Collections.sort(statlist, Comparator.comparing(stat -> stat.GUID()));
        ArrayList<Stat> misc = new ArrayList<Stat>();
        for (Stat stat2 : statlist) {
            List same = statlist.stream().filter(x -> x.getClass() == stat2.getClass()).collect(Collectors.toList());
            if (same.size() > 1) {
                this.statmap.put(stat2.getClass().getName(), same);
                continue;
            }
            misc.add(stat2);
        }
        this.statmap.put("misc", misc);
    }

    public boolean mouseClicked(double X, double Y, int idk) {
        if (super.mouseClicked(X, Y, idk)) {
            return true;
        }
        for (Stat.StatGroup group : Stat.StatGroup.values()) {
            int x = group.X() + this.getGUIStartX();
            int y = group.Y + this.getGUIStartY();
            ((Object)((Object)group)).getClass();
            ((Object)((Object)group)).getClass();
            if (!GuiUtils.isInRect(x, y, 18, 18, (int)X, (int)Y)) continue;
            this.currentElement = 0;
            this.statgroup = group;
            this.genStatList();
        }
        return true;
    }

    class StatButton
    extends ImageButton {
        FontRenderer font;
        Stat stat;
        EntityCap.UnitData unitdata;

        public StatButton(EntityCap.UnitData unitdata, Stat statData, int xPos, int yPos) {
            super(xPos, yPos, button_sizeX, button_sizeY, 0, 0, button_sizeY, BUTTON_TEX, button -> {});
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.stat = statData;
            this.unitdata = unitdata;
        }

        public void renderToolTip(int x, int y) {
            if (this.isInside(x, y)) {
                ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                tooltip.add(Styles.BLUECOMP().func_150257_a(this.stat.locName()));
                tooltip.add(Styles.GREENCOMP().func_150257_a(this.stat.locDesc()));
                StatOverviewGUI.this.renderTooltip(TooltipUtils.compsToStrings(tooltip), x, y, Minecraft.func_71410_x().field_71466_p);
            }
        }

        public boolean isInside(int x, int y) {
            return GuiUtils.isInRect(this.getIconX(), this.getIconY(), button_sizeX, button_sizeY, x, y);
        }

        public int getIconX() {
            return this.x - 22;
        }

        public int getIconY() {
            return this.y - StatOverviewGUI.this.getHeightSpacing() / 4;
        }

        public void renderButton(int x, int y, float f) {
            if (!(this.stat instanceof UnknownStat)) {
                String str = StatOverviewGUI.this.getStatString(this.stat, this.unitdata);
                ResourceLocation res = this.stat.getIconLocation();
                RenderUtils.renderIcon(res, this.getIconX(), this.getIconY());
                StatOverviewGUI.this.drawString(this.font, str, this.x, this.y, TextFormatting.GOLD.func_211163_e());
            }
        }
    }
}

