/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.stat_calculation;

import com.robertx22.mine_and_slash.database.stats.Trait;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.ICoreStat;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.IPreCoreStat;
import com.robertx22.mine_and_slash.db_lists.initializers.Stats;
import com.robertx22.mine_and_slash.potion_effects.IStatGivingPotion;
import com.robertx22.mine_and_slash.potion_effects.IStatPotion;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.saveclasses.effects.StatusEffectData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatModsContainer;
import com.robertx22.mine_and_slash.saveclasses.mapitem.MapAffixData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.PlayerMapCap;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAffectsStats;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatConversion;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatTransfer;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;

public class CommonStatUtils {
    public static void addCustomStats(EntityCap.UnitData data, Unit unit, int level) {
        for (StatModData stat : data.getCustomStats().stats.values()) {
            stat.useOnPlayer(data);
        }
    }

    public static void addExactCustomStats(EntityCap.UnitData data) {
        for (ExactStatData stat : data.getCustomExactStats().stats.values()) {
            stat.applyStats(data);
        }
    }

    public static void addPotionStats(LivingEntity entity, EntityCap.UnitData data) {
        for (EffectInstance instance : entity.func_70651_bq()) {
            if (instance.func_188419_a() instanceof IStatGivingPotion) {
                IStatGivingPotion pot = (IStatGivingPotion)instance.func_188419_a();
                pot.getStats(instance).forEach(x -> x.useOnPlayer(data));
            }
            if (!(instance.func_188419_a() instanceof IStatPotion)) continue;
            IStatPotion stat = (IStatPotion)instance.func_188419_a();
            stat.applyStats(data, instance);
        }
    }

    public static void AddStatusEffectStats(Unit unit, int level) {
        for (StatusEffectData status : unit.statusEffects.values()) {
            List<IStatModsContainer.LevelAndStats> levelsandstats = status.GetAllStats(level);
            for (IStatModsContainer.LevelAndStats levelstat : levelsandstats) {
                for (StatModData data : levelstat.mods) {
                    StatData stat = unit.getStat(data.getStatMod().GetBaseStat());
                    if (stat == null) continue;
                    data.Add(stat, level);
                }
            }
        }
    }

    public static void CalcTraitsAndCoreStats(EntityCap.UnitData unit) {
        StatData statdata;
        Unit theunit = unit.getUnit();
        for (IPreCoreStat iPreCoreStat : Stats.allPreGenMapStatLists.get(IPreCoreStat.class)) {
            statdata = theunit.getStat(iPreCoreStat.GUID());
            if (!(statdata.Value > 0.0f)) continue;
            iPreCoreStat.addToCoreStats(unit, statdata);
        }
        for (ICoreStat iCoreStat : Stats.allPreGenMapStatLists.get(ICoreStat.class)) {
            statdata = theunit.getStat(iCoreStat.GUID());
            if (!(statdata.Value > 0.0f)) continue;
            iCoreStat.addToOtherStats(unit, statdata);
        }
        for (Trait trait : Stats.allPreGenMapStatLists.get(Trait.class)) {
            statdata = theunit.getStat(trait.GUID());
            if (!(statdata.Value > 0.0f)) continue;
            trait.TryAffectOtherStats(unit, statdata);
        }
        for (IAffectsStats iAffectsStats : Stats.allPreGenMapStatLists.get(IAffectsStats.class)) {
            statdata = theunit.getStat(iAffectsStats.GUID());
            if (!(statdata.Value > 0.0f)) continue;
            iAffectsStats.affectStats(unit, statdata);
        }
    }

    public static void CalcStatConversionsAndTransfers(Unit copy, Unit unit) {
        StatData statdata;
        for (IStatConversion iStatConversion : Stats.allPreGenMapStatLists.get(IStatConversion.class)) {
            statdata = copy.getStat(iStatConversion.GUID());
            if (!(statdata.Value > 0.0f)) continue;
            iStatConversion.convertStats(copy, unit, copy.getStat(iStatConversion.GUID()));
        }
        for (IStatTransfer iStatTransfer : Stats.allPreGenMapStatLists.get(IStatTransfer.class)) {
            statdata = copy.getStat(iStatTransfer.GUID());
            if (!(statdata.Value > 0.0f)) continue;
            iStatTransfer.transferStats(copy, unit, copy.getStat(iStatTransfer.GUID()));
        }
    }

    public static void AddMapAffixStats(PlayerMapCap.IPlayerMapData mapdata, Unit unit, int level, LivingEntity entity) {
        for (MapAffixData status : WorldUtils.getAllAffixesThatAffect(mapdata, entity)) {
            List<StatModData> datas = status.GetAllStats();
            for (StatModData data : datas) {
                StatData stat = unit.getStat(data.getStatMod().GetBaseStat());
                if (stat == null) continue;
                data.Add(stat, level);
            }
        }
    }
}

