/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.stat_calculation;

import com.robertx22.mine_and_slash.config.whole_mod_entity_configs.ModEntityConfig;
import com.robertx22.mine_and_slash.database.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.types.defense.Armor;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalPene;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalSpellDamage;
import com.robertx22.mine_and_slash.database.stats.types.offense.CriticalDamage;
import com.robertx22.mine_and_slash.database.stats.types.offense.CriticalHit;
import com.robertx22.mine_and_slash.database.stats.types.offense.PhysicalDamage;
import com.robertx22.mine_and_slash.database.stats.types.resources.Health;
import com.robertx22.mine_and_slash.database.status_effects.bases.BaseStatusEffect;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.saveclasses.effects.StatusEffectData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MobStatUtils {
    static int spelldmg = 12;
    static int elePene = 8;
    static int spellresist = 3;

    public static void increaseMobStatsPerTier(EntityCap.UnitData mobdata, Unit unit) {
        for (StatData data : unit.getStats().values().stream().filter(x -> !x.GetStat().IsPercent()).collect(Collectors.toList())) {
            data.Flat *= mobdata.getStatMultiplierIncreaseByTier();
        }
    }

    public static void worldMultiplierStats(World world, Unit unit) {
        for (StatData stat : unit.getStats().values()) {
            stat.Flat *= SlashRegistry.getDimensionConfig((IWorld)world).MOB_STRENGTH_MULTIPLIER;
        }
    }

    public static void modifyMobStatsByConfig(LivingEntity entity, EntityCap.UnitData unitdata) {
        Unit unit = unitdata.getUnit();
        ModEntityConfig config = SlashRegistry.getEntityConfig(entity, unitdata);
        for (StatData data : unit.getStats().values()) {
            Stat stat = data.GetStat();
            if (stat instanceof PhysicalDamage || stat instanceof ElementalSpellDamage || stat instanceof CriticalDamage || stat instanceof CriticalHit) {
                data.Flat = (float)((double)data.Flat * config.DMG_MULTI);
                continue;
            }
            if (data.Name.equals(Health.GUID)) {
                data.Flat = (float)((double)data.Flat * config.HP_MULTI);
                continue;
            }
            data.Flat = (float)((double)data.Flat * config.STAT_MULTI);
        }
    }

    public static void AddMobcStats(EntityCap.UnitData unitdata, int level) {
        MobRarity rar = (MobRarity)Rarities.Mobs.get(unitdata.getRarity());
        Unit unit = unitdata.getUnit();
        unit.getStat(Armor.GUID).addFlat(11.0f * rar.StatMultiplier(), level);
        unit.getStat((String)CriticalHit.GUID).Flat += 5.0f * rar.DamageMultiplier();
        unit.getStat((String)CriticalDamage.GUID).Flat += 5.0f * rar.DamageMultiplier();
        for (Elements element : Elements.getAllSingleElements()) {
            unit.getStat(new ElementalResist(element).GUID()).addFlat((float)spellresist * rar.StatMultiplier(), level);
            unit.getStat(new ElementalSpellDamage(element).GUID()).addFlat((float)spelldmg * rar.DamageMultiplier(), level);
        }
        for (Elements element : Elements.getAllExceptNone()) {
            unit.getStat(new ElementalPene(element).GUID()).addFlat((float)elePene * rar.DamageMultiplier(), level);
        }
    }

    public static void AddRandomMobStatusEffects(LivingEntity entity, Unit unit, MobRarity rarity) {
        int max = rarity.MaxMobEffects();
        if (max > 0) {
            if (max > SlashRegistry.StatusEffects().getAll().values().size()) {
                System.out.println("ERROR! Can't have more unique effects than there are effects!");
                max = SlashRegistry.StatusEffects().getAll().values().size() - 1;
            }
            for (int amount = RandomUtils.RandomRange(0, max); amount > 0; --amount) {
                BaseStatusEffect effect = null;
                while (effect == null || unit.statusEffects.containsKey(effect.GUID())) {
                    effect = RandomUtils.weightedRandom(SlashRegistry.StatusEffects().getAll().values());
                }
                unit.statusEffects.put(effect.GUID(), new StatusEffectData(effect));
            }
        }
    }
}

