/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.stat_calculation;

import com.robertx22.mine_and_slash.config.ModConfig;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.stats.types.defense.Armor;
import com.robertx22.mine_and_slash.database.stats.types.offense.CriticalDamage;
import com.robertx22.mine_and_slash.database.stats.types.offense.CriticalHit;
import com.robertx22.mine_and_slash.database.stats.types.offense.PhysicalDamage;
import com.robertx22.mine_and_slash.database.stats.types.offense.SpellDamage;
import com.robertx22.mine_and_slash.database.stats.types.resources.Energy;
import com.robertx22.mine_and_slash.database.stats.types.resources.EnergyRegen;
import com.robertx22.mine_and_slash.database.stats.types.resources.Health;
import com.robertx22.mine_and_slash.database.stats.types.resources.HealthRegen;
import com.robertx22.mine_and_slash.database.stats.types.resources.MagicShield;
import com.robertx22.mine_and_slash.database.stats.types.resources.MagicShieldRegen;
import com.robertx22.mine_and_slash.database.stats.types.resources.Mana;
import com.robertx22.mine_and_slash.database.stats.types.resources.ManaRegen;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.saveclasses.WornSetsContainerData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatModsContainer;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.PlayerTalentsCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;

public class PlayerStatUtils {
    public static void AddPlayerBaseStats(EntityCap.UnitData data, Unit unit) {
        PlayerStatUtils.addScalingStat(data, SpellDamage.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.spell_damage.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.spell_damage_per_level.get());
        PlayerStatUtils.addScalingStat(data, PhysicalDamage.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.physical_damage.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.physical_damage_per_level.get());
        PlayerStatUtils.addScalingStat(data, HealthRegen.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.health_regen.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.health_regen_per_level.get());
        PlayerStatUtils.addScalingStat(data, Armor.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.armor.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.armor_per_level.get());
        PlayerStatUtils.addScalingStat(data, Health.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.health.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.health_per_level.get());
        PlayerStatUtils.addScalingStat(data, MagicShield.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.magic_shield.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.magic_shield_per_level.get());
        PlayerStatUtils.addScalingStat(data, MagicShieldRegen.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.magic_shield_regen.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.magic_shield_regen_per_level.get());
        PlayerStatUtils.addScalingStat(data, CriticalHit.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.critical_hit.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.critical_hit_per_level.get());
        PlayerStatUtils.addScalingStat(data, CriticalDamage.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.critical_damage.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.critical_damage_per_level.get());
        PlayerStatUtils.addScalingStat(data, ManaRegen.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.mana_regen.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.mana_regen_per_level.get());
        PlayerStatUtils.addScalingStat(data, EnergyRegen.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.energy_regen.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.energy_regen_per_level.get());
        PlayerStatUtils.addScalingStat(data, Energy.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.energy.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.energy_per_level.get());
        PlayerStatUtils.addScalingStat(data, Mana.GUID, (Double)ModConfig.INSTANCE.PlayerBaseStats.mana.get(), (Double)ModConfig.INSTANCE.PlayerBaseStats.mana_per_level.get());
    }

    private static void addScalingStat(EntityCap.UnitData data, String stat, double base, double perlvl) {
        data.getUnit().getStat((String)stat).Flat = (float)((double)data.getUnit().getStat((String)stat).Flat + base);
        data.getUnit().getStat(stat).addFlat((float)perlvl, data.getLevel());
    }

    public static void CountWornSets(Entity entity, List<GearItemData> gears, Unit unit) {
        unit.wornSets = new WornSetsContainerData();
        for (GearItemData gear : gears) {
            unit.wornSets.addSet(gear);
        }
    }

    public static void AddAllSetStats(Entity entity, EntityCap.UnitData data, Unit unit, int level) {
        unit.wornSets.AddAllSetStats(data);
    }

    public static void applyRequirementsUnmetPenalty(Entity en, EntityCap.UnitData data, List<GearItemData> gears) {
        float penalty = 1.0f;
        for (GearItemData gearItemData : gears) {
            if (gearItemData.meetsRequirements(data)) continue;
            penalty -= 0.25f;
        }
        if ((penalty = MathHelper.func_76131_a((float)penalty, (float)0.1f, (float)1.0f)) < 1.0f) {
            for (Map.Entry entry : data.getUnit().getStats().entrySet()) {
                if (!(((StatData)entry.getValue()).Value > 0.0f)) continue;
                ((StatData)entry.getValue()).Value *= penalty;
            }
        }
    }

    public static void AddAllGearStats(Entity entity, List<GearItemData> gears, EntityCap.UnitData unitdata, int level) {
        for (GearItemData gear : gears) {
            if (gear.level > unitdata.getLevel()) continue;
            List<IStatModsContainer.LevelAndStats> levelstats = gear.GetAllStats(gear.level);
            for (IStatModsContainer.LevelAndStats datas : levelstats) {
                for (StatModData data : datas.mods) {
                    StatData statdata;
                    Stat stat;
                    StatMod mod = data.getStatMod();
                    if (mod == null || (stat = data.getStatMod().GetBaseStat()) == null || (statdata = unitdata.getUnit().getStat(stat)) == null) continue;
                    data.Add(statdata, datas.level);
                }
            }
        }
    }

    public static void addTalentStats(EntityCap.UnitData data, PlayerEntity player) {
        PlayerTalentsCap.IPlayerTalentsData talents = Load.talents(player);
        talents.applyStats(data, player);
    }
}

