/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.config.dimension_configs.DimensionConfig;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class LevelUtils {
    public static int determineLevel(World world, BlockPos pos) {
        DimensionConfig dimConfig = SlashRegistry.getDimensionConfig((IWorld)world);
        int lvl = 1;
        if (dimConfig.SCALE_MOB_LEVEL_TO_NEAREST_PLAYER) {
            PlayerEntity player = world.func_190525_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 3000.0, EntityPredicates.field_180132_d);
            if (player != null) {
                lvl = Load.Unit((ICapabilityProvider)player).getLevel();
            }
        } else {
            lvl = LevelUtils.determineLevelPerDistanceFromSpawn(world, pos, dimConfig);
        }
        lvl = MathHelper.func_76125_a((int)lvl, (int)dimConfig.MINIMUM_MOB_LEVEL, (int)dimConfig.MAXIMUM_MOB_LEVEL);
        return lvl;
    }

    public static int determineLevelPerDistanceFromSpawn(World world, BlockPos pos, DimensionConfig config) {
        double distance = world.func_175694_M().func_218139_n((Vec3i)pos);
        int lvl = 1;
        lvl = distance < (double)config.MOB_LEVEL_ONE_AREA ? config.MINIMUM_MOB_LEVEL : (int)(1.0 + (distance - (double)config.MOB_LEVEL_ONE_AREA) / (double)config.MOB_LEVEL_PER_DISTANCE);
        return MathHelper.func_76125_a((int)lvl, (int)config.MINIMUM_MOB_LEVEL, (int)config.MAXIMUM_MOB_LEVEL);
    }

    public static BlockPos getAreaPosOfLevel(World world, int level, DimensionConfig config) {
        if (level == 1) {
            return world.func_175694_M();
        }
        int distance = config.MOB_LEVEL_PER_DISTANCE * level;
        BlockPos pos = new BlockPos(distance, 0, world.func_175694_M().func_177952_p());
        return pos;
    }

    public static int determineLevelPerDistanceFromSpawn(World world, BlockPos pos) {
        return LevelUtils.determineLevelPerDistanceFromSpawn(world, pos, SlashRegistry.getDimensionConfig((IWorld)world));
    }
}

