/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class LookUtils {
    public static Entity getEntityLookedAt(Entity e) {
        Entity foundEntity = null;
        double finalDistance = 32.0;
        double distance = 32.0;
        RayTraceResult pos = LookUtils.raycast(e, 32.0);
        Vec3d positionVector = e.func_174791_d();
        if (e instanceof PlayerEntity) {
            positionVector = positionVector.func_72441_c(0.0, (double)e.func_70047_e(), 0.0);
        }
        if (pos != null) {
            distance = pos.func_216347_e().func_72438_d(positionVector);
        }
        Vec3d lookVector = e.func_70040_Z();
        Vec3d reachVector = positionVector.func_72441_c(lookVector.field_72450_a * 32.0, lookVector.field_72448_b * 32.0, lookVector.field_72449_c * 32.0);
        Entity lookedEntity = null;
        List entitiesInBoundingBox = e.func_130014_f_().func_72839_b(e, e.func_174813_aQ().func_72314_b(lookVector.field_72450_a * 32.0, lookVector.field_72448_b * 32.0, lookVector.field_72449_c * 32.0).func_72321_a(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            if (entity.func_70067_L()) {
                double distanceToEntity;
                float collisionBorderSize = entity.func_70111_Y();
                AxisAlignedBB hitbox = entity.func_174813_aQ().func_72321_a((double)collisionBorderSize, (double)collisionBorderSize, (double)collisionBorderSize);
                Optional interceptPosition = hitbox.func_216365_b(positionVector, reachVector);
                Vec3d interceptVec = interceptPosition.orElse(null);
                if (hitbox.func_72318_a(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptVec != null && ((distanceToEntity = positionVector.func_72438_d(interceptVec)) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance) && pos != null) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    public static RayTraceResult raycast(Entity e, double len) {
        Vec3d look;
        Vec3d vec = new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v);
        if (e instanceof PlayerEntity) {
            vec = vec.func_178787_e(new Vec3d(0.0, (double)e.func_70047_e(), 0.0));
        }
        if ((look = e.func_70040_Z()) == null) {
            return null;
        }
        return LookUtils.raycast(e.func_130014_f_(), vec, look, e, len);
    }

    public static RayTraceResult raycast(World world, Vec3d origin, Vec3d ray, Entity e, double len) {
        Vec3d end = origin.func_178787_e(ray.func_72432_b().func_186678_a(len));
        BlockRayTraceResult pos = world.func_217299_a(new RayTraceContext(origin, end, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, e));
        return pos;
    }
}

